package {
	import flash.display.Sprite;	
	import flash.utils.Timer;
	import flash.events.TimerEvent;	
	import flash.utils.getTimer;
	
	public class HelicalMotion extends Sprite {
		private var ball:Ball;
		private var timer:Timer;
		private var t:int;
		private var theta:Number=0;
		private var omega:Number=2;
		private var vz:Number=10; // prędkość podawana w px/s		

		public function HelicalMotion() {
			init();
		}
		private function init():void {		
			createBall();
			setupTimer(); 
		}
		
		private function createBall():void{
			ball = new Ball();	
			ball.x = 300;
			ball.y = 200;
			ball.z = 0;
			addChild(ball);	
		}
		
		private function setupTimer():void{
			timer = new Timer(20);
			timer.addEventListener(TimerEvent.TIMER,onEachTimestep);		
			timer.start();
			t = getTimer(); // zainicjowanie wartości zmiennej t
		}

		private function onEachTimestep(evt:TimerEvent):void{
			var dt:Number = (getTimer() - t)/1000; // czas (w sekundach), jaki upłynął od poprzedniego wywołania
			t = getTimer(); // resetuje zmienną t			
			theta += omega*dt;
//			ball.x = 100*Math.cos(theta) + 200;
//			ball.z = 100*Math.sin(theta) + 200;
			ball.x = 100*Math.cos(theta)*Math.exp(-theta/20) + 200;
			ball.z = 100*Math.sin(theta)*Math.exp(-theta/10) + 200;
			ball.y += vz*dt;
			evt.updateAfterEvent();
		}
	}
}