package {
	import flash.display.Sprite;	
	import flash.events.Event;
	
	public class BouncingBall3DWalls extends Sprite {
		private var g:Number=0.1; // przyśpieszenie grawitacyjne
		private var vx:Number;  // początkowa pozioma składowa prędkości
		private var vy:Number;  // początkowa pionowa składowa prędkości
		private var vz:Number;  // boczna składowa prędkości
		private var ball:Ball;
		private var w:Number;
		private var gfac:Number=-0.99;
		private var wfac:Number=-0.99;

		public function BouncingBall3DWalls() {
			//root.transform.perspectiveProjection.focalLength = 300;
			init();
		}
		private function init():void {		
			setWall(0,200,250,300,400,-90); // lewa ściana
			setWall(550,200,250,300,400,90); // prawa ściana		
			setWall(275,200,400,548,400,0); // tylna ściana						
			vx = Math.random()*5;
			vy = (Math.random()-0.5)*4;
			vz = 4;
			ball = new Ball();	
			ball.x = 100;
			ball.y = 75;
			ball.z = 0;
			w = ball.width/2;
			addChild(ball);	
			addEventListener(Event.ENTER_FRAME,onEachTimestep); 
			setWall(275,200,100,550,400,0,0x0000ff,0.2); // bliższa ściana
		}

		private function setWall(pX:Number,pY:Number,pZ:Number,pW:Number,pH:Number,pAngle:Number,pCol:uint=0x586cbf,pAlp:Number=1):void{
			var wall:Wall = new Wall(pW,pH,pCol,pAlp);
			wall.x=pX;
			wall.y=pY;
			wall.z=pZ;
			wall.rotationY=pAngle;
			addChild(wall);
		}

		private function onEachTimestep(evt:Event):void{

			vy += g;      // grawitacja zwiększa pionową składową prędkości
			
			ball.x += vx; // prędkość pozioma zwiększa przemieszczenie ciała w poziomie
			ball.y += vy; // prędkość pionowa zwiększa przemieszczenie ciała w pionie
			ball.z += vz;
			
			if (ball.y > 350){ // w przypadku zderzenia z podłożem
				ball.y = 350;
				vy *= gfac;    // wektor prędkości pionowej ulega odwróceniu i skróceniu
			}
			if (ball.x > 550 - w){
				ball.x = 550 - w;
				vx *= wfac;
			}
			if (ball.x < w){
				ball.x = w;
				vx *= wfac;
			}
			if (ball.z > 400){
				ball.z = 400;
				vz *= wfac;
			}
			if (ball.z < 100){
				ball.z = 100;
				vz *= wfac;
			}
			//trace(ball.z);
			//trace(vz);

		}
	}
}





