package{
	import flash.display.Sprite;
	import com.physicscodes.objects.BallRB;
	import com.physicscodes.math.Vector2D;	

	public class Rolling extends Sprite{
		public function Rolling():void{
			init();
		}
		private function init():void{
			// tworzy równię pochyłą
			var xtop:Number=50;
			var ytop:Number=150;			
			var xbot:Number=450;
			var ybot:Number=250;
			
			var surface:Sprite = new Sprite;
			with (surface.graphics) {
				lineStyle(1,0x333333,1);
				moveTo(xtop,ytop);
				lineTo(xbot,ybot);
			}
			addChild(surface);			
			var angle:Number = Math.atan2(ybot-ytop,xbot-xtop);
			//trace("angle is " + angle + " radians, or " + angle*180/Math.PI + " degrees");
			
			// tworzy kulistą bryłę sztywną		
			var radius:Number = 20; 
			var cm:Vector2D = new Vector2D(xtop+radius*Math.sin(angle),ytop-radius*Math.cos(angle));			
			var ball:BallRB = new BallRB(cm,radius,0x0000ff);
			ball.mass = 20;
			ball.momentOfInertia = 0.4*ball.mass*ball.radius*ball.radius; // dla kuli
//			ball.momentOfInertia = 0.5*ball.mass*ball.radius*ball.radius; // dla walca			
			addChild(ball);

			// wprawia kulkę w ruch
			var mover:RollingMover=new RollingMover(ball,angle);		
			mover.startTime();
		}
	}
}