package {
	import flash.display.Sprite;
	import com.physicscodes.motion.MultiForcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;
	import com.physicscodes.objects.Ball;	
	import com.physicscodes.math.Vector2D;

	public class SmokeMover extends MultiForcer{

		private var _sprite:Sprite;
		private var _particles:Array = new Array();
		private var _maxParticles:uint = 120;		
		private var _g:Number = -5;
		private var _k:Number = 0.005;
		private var _vx:Number = 60;
		private var _vy:Number = -80;
		
		public function SmokeMover(psprite:Sprite):void{		
			_sprite = psprite;
			super(_particles);
		}	
		
		override protected function calcForce(pparticle:Particle):void{
			var gravity:Vector2D = Forces.constantGravity(pparticle.mass,_g);	
			var drag:Vector2D = Forces.drag(_k,pparticle.velo2D);
			force = Forces.add([gravity, drag]);
		}
		
		override protected function moveObject():void{
			super.moveObject();
			createNewParticles(new Vector2D(_sprite.mouseX,_sprite.mouseY));
			limitParticles();
			modifyParticles();
		}		
		
		private function createNewParticles(ppos:Vector2D):void{
			var radius:Number = 1 + 3*Math.random();
			var newBall:Ball = new Ball(radius,0xffffff);
			newBall.pos2D = ppos;
			newBall.velo2D = new Vector2D((Math.random()-0.5)*_vx,(Math.random()+0.5)*_vy);
			_sprite.addChild(newBall);
			_particles.push(newBall);
		}		
		
		private function limitParticles():void{
			if (_particles.length > _maxParticles){
				_sprite.removeChild(_particles[0]);
				_particles.shift();
			}
		}
		
		private function modifyParticles():void{
			for (var i:uint=0; i<_particles.length; i++){		
				var particle:Ball = _particles[i];
				particle.scaleX *= 1.01;
				particle.scaleY *= 1.01;
				particle.alpha += -0.01;
			}
		}
		
	}
}
