package{
	import flash.display.Sprite;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.math.Vector2D;	
	import com.physicscodes.objects.Particle;

	public class SatelliteDemo2 extends Sprite{
		public function SatelliteDemo2():void{
			init();
		}
		private function init():void{
			// tworzy 100 rozmieszczonych losowo gwiazd
			for (var i:uint=0; i<100; i++){
				var star:Ball = new Ball(Math.random()*3,0xffff00);
				star.pos2D = new Vector2D(Math.random()*stage.stageWidth,Math.random()*stage.stageHeight);
				addChild(star);
			}
			
			// tworzy obracającą się Ziemię
			var earth:Ball;
			earth = new Ball(70,0x0099ff,1000000);
			earth.pos2D = new Vector2D(400,300);			
			earth.angVelo = 0.4;
			addChild(earth);

			// tworzy poruszającego się satelitę
			var satellite:Ball;
			satellite = new Ball(8,0x999999,1);
//			satellite.pos2D = new Vector2D(600,300);	
			satellite.pos2D = new Vector2D(584.2,300);				
			satellite.angVelo = earth.angVelo;
			// rysuje anteny
			with (satellite.graphics){
				lineStyle(2,0xffffff);
				moveTo(0,0);
				lineTo(-20,-10);
				moveTo(0,0);
				lineTo(-20,10);				
				moveTo(0,0);
				lineTo(-15,0);					
			}
			addChild(satellite);

			// wprawia satelitę w ruch na orbicie Ziemi
			var orbiter:SatelliteOrbiter2=new SatelliteOrbiter2(satellite,earth);		
			orbiter.startTime(10);
			
			// wprawia Ziemię w ruch
			earth.move();
		}
	}
}