package {
	import flash.display.Sprite;	
	import flash.events.Event;
	
	public class BouncingBall3DWalls extends Sprite {
		private var g:Number=0.1; // przyśpieszenie due to gravity
		private var vx:Number;  // initial horizontal speed
		private var vy:Number;  // initial vertical speed
		private var vz:Number;  // lateral speed
		private var ball:Ball;
		private var w:Number;
		private var gfac:Number=-0.99;
		private var wfac:Number=-0.99;

		public function BouncingBall3DWalls() {
			//root.transform.perspectiveProjection.focalLength = 300;
			init();
		}
		private function init():void {		
			setWall(0,200,250,300,400,-90); // left wall
			setWall(550,200,250,300,400,90); // right wall			
			setWall(275,200,400,548,400,0); // far wall						
			vx = Math.random()*5;
			vy = (Math.random()-0.5)*4;
			vz = 4;
			ball = new Ball();	
			ball.x = 100;
			ball.y = 75;
			ball.z = 0;
			w = ball.width/2;
			addChild(ball);	
			addEventListener(Event.ENTER_FRAME,onEachTimestep); 
			setWall(275,200,100,550,400,0,0x0000ff,0.2); // near wall
		}

		private function setWall(pX:Number,pY:Number,pZ:Number,pW:Number,pH:Number,pAngle:Number,pCol:uint=0x586cbf,pAlp:Number=1):void{
			var wall:Wall = new Wall(pW,pH,pCol,pAlp);
			wall.x=pX;
			wall.y=pY;
			wall.z=pZ;
			wall.rotationY=pAngle;
			addChild(wall);
		}

		private function onEachTimestep(evt:Event):void{

			vy += g;      // przyśpieszenie grawitacyjne increases the vertical speed
			
			ball.x += vx; // horizontal speed increases horizontal position
			ball.y += vy; // vertical speed increases vertical position
			ball.z += vz;
			
			if (ball.y > 350){ // if ball hits the ground
				ball.y = 350;
				vy *= gfac;    // its vertical velocity reverses and reduces
			}
			if (ball.x > 550 - w){
				ball.x = 550 - w;
				vx *= wfac;
			}
			if (ball.x < w){
				ball.x = w;
				vx *= wfac;
			}
			if (ball.z > 400){
				ball.z = 400;
				vz *= wfac;
			}
			if (ball.z < 100){
				ball.z = 100;
				vz *= wfac;
			}
			//trace(ball.z);
			//trace(vz);

		}
	}
}





