﻿package com.physicscodes.objects {
	import flash.geom.Vector3D;	
	import com.physicscodes.objects.Particle3D;

	public class RigidBody3D extends Particle3D{
		private var _cm:Vector3D; 	// center of mass		
		private var _im:Vector3D;	// moment of inertia vector (Ixx,Iyy,Izz)

		public function RigidBody3D(pcm:Vector3D,pim:Vector3D,pmass:Number=1,pcharge:Number=0){
			this.mass = pmass;
			this.charge = pcharge;			
			this.pos = pcm; // define postion of rigid body as its center of mass 			
			_cm = pcm;
			_im = pim;
			super(pmass,pcharge);
		}
		
		public function get Im():Vector3D{
			return _im;
		}
		public function set Im(pim:Vector3D):void{
			_im = pim;
		}				

		public function get centerOfMass():Vector3D{
			return _cm;
		}
		public function set centerOfMass(pcm:Vector3D):void{
			_cm = pcm;
			this.pos = pcm; 	
		}
		
	}
}