package{
	import flash.display.Sprite;
	import com.physicscodes.math.Vector3DX;
	import com.physicscodes.objects.Ball;
	
	public class SinglePlanet extends Sprite{
		
		private var _dt:Number = 0.05;
		private var _numSteps:Number = 2500;
		private var _animFreq:Number = 40;
		private var _t:Number = 0;
		//private var _v:Vector3DX = new Vector3DX(10,0,10);			
		private var _v:Vector3DX = new Vector3DX(5,0,14);			
		private var _s:Vector3DX = new Vector3DX(400,150,0);	
		private var _center:Vector3DX = new Vector3DX(400,400,0);
		private var _G:Number = 10;
		private var _massSun:Number = 5000;
		private var _planet:Ball;
		private var _sun:Ball;		
				
		public function SinglePlanet():void{
			init();
		}
		
		private function init():void{
			setup();
			simulate();
		}
		
		private function setup():void{
			_sun = new Ball(30,0xffff00);
			_sun.pos = _center;
			addChild(_sun);
			
			_planet = new Ball(5);
			_planet.pos = _s;
			addChild(_planet);
		}		
		
		private function simulate():void{
			for (var i:uint=0; i<_numSteps; i++){
				_t += _dt; 				
				RK4();
				if (i%_animFreq==0){
					animate();
				}
			}
		}

		private function animate():void{
			_planet.pos = _s;
			clonePlanet();
		}		

		private function clonePlanet():void{
			var pcopy:Ball = _planet.clone();
			pcopy.pos = _planet.pos;
			addChild(pcopy);			
		}
		
		private function getAcc(ppos:Vector3DX,pvel:Vector3DX):Vector3DX{
			var r:Vector3DX = Vector3DX.convert(ppos.subtract(_center));
			return r.multiply(-_G*_massSun/(r.lengthSquared*r.length));
		}		
		
		private function RK4():void{			
			// krok 1
			var pos1:Vector3DX = _s;
			var vel1:Vector3DX = _v;
			var acc1:Vector3DX = getAcc(pos1,vel1); 
			// krok 2
			var pos2:Vector3DX = pos1.addScaled(vel1,_dt/2); 
			var vel2:Vector3DX = vel1.addScaled(acc1,_dt/2);
			var acc2:Vector3DX = getAcc(pos2,vel2); 
			// krok 3
			var pos3:Vector3DX = pos1.addScaled(vel2,_dt/2); 
			var vel3:Vector3DX = vel1.addScaled(acc2,_dt/2);
			var acc3:Vector3DX = getAcc(pos3,vel3); 
			// krok 4
			var pos4:Vector3DX = pos1.addScaled(vel3,_dt); 
			var vel4:Vector3DX = vel1.addScaled(acc3,_dt);
			var acc4:Vector3DX = getAcc(pos4,vel4); 
			// sumuje vel i acc
			var velsum:Vector3DX = vel1.addScaled(vel2,2).addScaled(vel3,2).addScaled(vel4,1);
			var accsum:Vector3DX = acc1.addScaled(acc2,2).addScaled(acc3,2).addScaled(acc4,1);
			// aktualizuje wartość położenia and velo
			_s = pos1.addScaled(velsum,_dt/6);
			_v = vel1.addScaled(accsum,_dt/6);			
			//_acc = accsum.multiply(1/6);
		}
		
	}
}