﻿package {
	import com.physicscodes.math.Graph;
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.motion.ForcerIntegrator;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.objects.Particle;			

	public class Projector extends ForcerIntegrator{
		private var _particle:Particle;				
		private var _graph:Graph;		
		private var _stageWidth:Number;
		private var _stageHeight:Number;		
		private var _g:Number = 10;
		private var _x0:Vector2D;
		private var _u:Vector2D;

		public function Projector(pparticle:Particle):void{
			_particle = pparticle;
			_x0 = _particle.pos2D;			
			_u = _particle.velo2D;
			_stageWidth = _particle.stage.stageWidth;			
			_stageHeight = _particle.stage.stageHeight;				
			setupGraph();		
			super(pparticle);
		}	
		
		override protected function calcForce(ppos:Vector2D,pvel:Vector2D):void{
			force = Forces.constantGravity(_particle.mass,_g);	
		}
	
		override protected function moveObject():void{
			super.moveObject();
			plotGraph();		
		}	
		
		private function setupGraph():void {
			//_graph= new Graph(xmin,xmax,ymin,ymax,xorig,yorig,xwidth,ywidth);	
			_graph= new Graph(0,_stageWidth,0,_stageHeight,0,0,_stageWidth,_stageHeight);						
			_particle.stage.addChild(_graph);
		}
		private function plotGraph():void{
			_graph.plot([_particle.xpos], [-_particle.ypos], 0x333333, false, true);		
			_graph.plot([_x0.x+_u.x*time], [-(_x0.y+_u.y*time+0.5*_g*time*time)], 0xff0000, false, true);					
		}				
		
	}
}
