﻿package {
	import flash.display.Sprite;
	import com.physicscodes.motion.MultiForcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;
	import com.physicscodes.objects.Ball;	
	import com.physicscodes.math.Vector2D;

	public class SplashMover extends MultiForcer{

		private var _drop:Ball;
		private var _particles:Array = new Array();
		private var _g:Number = 20;
		private var _vx:Number = 20;
		private var _vy:Number = -15;
		private var _wlevel:Number = 510;
		private var _fac:Number = 1;
		
		public function SplashMover(pdrop:Ball,psplash:Array):void{		
			_drop = pdrop;
			_particles = psplash;
			super(_particles);
		}	
		
		override protected function moveObject():void{
			super.moveObject();
			checkDrop();
		}	
		
		private function checkDrop():void{
			if (_drop.ypos > _wlevel){
				for (var i:uint=0; i<_particles.length; i++){
					var splashDrop:Ball = _particles[i];
					var posx:Number = _drop.xpos+(Math.random()-0.5)*_drop.width;
					var posy:Number = _wlevel-10+Math.random()*_drop.height;
					var velx:Number = (Math.random()-0.5)*_vx*_fac;
					var vely:Number = (Math.random()+0.5)*_vy*_fac;
					splashDrop.pos2D = new Vector2D(posx,posy);
					splashDrop.velo2D = new Vector2D(velx,vely);
				} 				
				_drop.xpos = Math.random()*600+100;
				_drop.ypos = 100;
				_drop.radius = 4 + 8*Math.random();
				_fac = Math.pow(_drop.radius/8,1.5);;
			}
		}
		
		override protected function calcForce(pparticle:Particle):void{
			force = Forces.constantGravity(pparticle.mass,_g);	
			if (pparticle.ypos > _wlevel){
				pparticle.visible = false;
			}else{
				pparticle.visible = true;
			}
		}
		
	}
}
