﻿package com.physicscodes.objects {
	import flash.display.Sprite;
	import com.physicscodes.objects.Particle;
	
	public class Box extends Particle{
		
		private var _boxWidth:Number;
		private var _boxHeight:Number;		
		private var _color:uint;
		private var _particle:Particle;

		public function Box(pboxWidth:Number=20,pboxHeight:Number=20,pcolor:uint=0x0000ff,pmass:Number=1,pcharge:Number=0){
			this.mass=pmass;
			this.charge=pcharge;
			_boxWidth=pboxWidth;
			_boxHeight=pboxHeight;
			_color=pcolor;
			_particle = new Particle(pmass,pcharge);
			drawBox();
		}

		private function drawBox():void{
			with (_particle.graphics){	
				beginFill(_color);
				drawRect(-_boxWidth/2,-_boxHeight/2,_boxWidth,_boxHeight);
				endFill();
			}
			addChild(_particle);
		}		
		
		public function clone():Box{
			return new Box(_boxWidth,_boxHeight,_color);			
		}
		
		public function clear():void{
			_particle.graphics.clear();
			removeChild(_particle);
		}

		public function get boxWidth():Number{
			return _boxWidth;
		}
		public function set boxWidth(pboxWidth:Number):void{
			_boxWidth = pboxWidth;
			clear();
			drawBox();
		}		
		
		public function get boxHeight():Number{
			return _boxHeight;
		}		
		public function set boxHeight(pboxHeight:Number):void{
			_boxHeight = pboxHeight;
			clear();
			drawBox();
		}
		
		public function get color():Number{
			return _color;
		}
		
		public function set color(pcolor:Number):void{
			_color = pcolor;
			clear();
			drawBox();
		}
	}
	
}
