package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.math.Vector2D;
	import flash.display.Sprite;
	import flash.events.MouseEvent;	
	
	public class DraggingOscillator extends Forcer{
		private var _object:Ball;
		private var _center:Vector2D;
		private var _displ:Vector2D;
		private var _g:Number=20;
		private var _kDamping=0.5;
		private var _kSpring=1;
		private var _springLength:Number=200;
		private var _spring:Sprite;

		public function DraggingOscillator(pobject:Ball,pfixedSupport:Ball,pspring:Sprite):void{
			_object = pobject;
            _center = pfixedSupport.pos2D;
			_spring = pspring;
			_object.addEventListener(MouseEvent.MOUSE_DOWN,onDown);			
			super(_object);
		}
		
		override protected function moveObject():void{		
			super.moveObject();
			drawSpring();
		}		
		
		private function drawSpring():void{
			with (_spring.graphics){
				clear();		
				lineStyle(2,0x999999);
				moveTo(_center.x,_center.y);
				lineTo(_object.x,_object.y)
			}
		}
		
		override protected function calcForce():void{
			_displ=_object.pos2D.subtract(_center);
			var gravity:Vector2D = Forces.constantGravity(_object.mass,_g);
			var damping:Vector2D = Forces.damping(_kDamping,_object.velo2D);	
			var extension:Vector2D = _displ.subtract(_displ.unit().multiply(_springLength));
			var restoring:Vector2D = Forces.spring(_kSpring,extension);
			force = Forces.add([gravity, damping, restoring]);
		}
		
		private function onDown(e:MouseEvent):void{
			_object.velo2D = new Vector2D(0,0);
			_object.stage.addEventListener(MouseEvent.MOUSE_UP,onUp);
			_object.startDrag(true);
			_spring.graphics.clear();
			stopTime();			
		}
		private function onUp(e:MouseEvent):void{
			//_object.ypos = _object.y;
			_object.pos2D = new Vector2D(_object.x,_object.y);			
			_object.stage.removeEventListener(MouseEvent.MOUSE_UP,onUp);
			_object.stopDrag();
			startTime(10);			
		}		
		
	}
}