﻿package {
	import flash.display.Sprite;
	import com.physicscodes.objects.Particle;
	import com.physicscodes.objects.Triangle;	
	
	public class Rocket extends Particle{
		private var _width:Number;
		private var _height:Number;		
		private var _color:uint;
		private var _particle:Particle;
		private var _exhaust:Triangle;

		public function Rocket(pwidth:Number=20,pheight:Number=40,pcolor:uint=0x0000ff,pmass:Number=1,pcharge:Number=0){
			this.mass=pmass;
			this.charge=pcharge;
			_width=pwidth;
			_height=pheight;
			_color=pcolor;
			_particle = new Particle(pmass,pcharge);
			drawRocket();
		}
		private function drawRocket():void{
			drawCapsule();
			drawTank();			
			drawExhaust();
			addChild(_particle);
		}		
		private function drawCapsule():void{	
			var triangle:Triangle = new Triangle(0,0,_width,1.5*_width,_color);
			addChild(triangle);
		}		
		private function drawTank():void{
			with (_particle.graphics){	
				beginFill(_color,1);
				drawRect(0,0,_width,_height);
				endFill();
			}			
		}
		private function drawExhaust():void{
			with (_particle.graphics){	
				_exhaust = new Triangle(0,_height+1.5*_width,_width,2.5*_width,_color,0.4);
				_particle.addChild(_exhaust);
			}
		}		
		public function stopExhaust():void{
			_particle.removeChild(_exhaust);
		}		
		public function clear():void{
			_particle.graphics.clear();
			removeChild(_particle);
		}	
		public function dropTank():void{
			clear();
		}
	}
}
