package {
	import com.physicscodes.motion.MultiForcer2;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;

	public class MultiGravitator extends MultiForcer2{
										
		private var _particles:Array;										
		private var _massAttractor:Number;		
		private var _center:Vector2D;
		private var _G:Number = 1;		
		private var _eps:Number = 1;
		private var _rmin:Number = 100;
		
		public function MultiGravitator(pparticles:Array,pattractor:Particle):void{		
			_massAttractor = pattractor.mass;			
			_center = pattractor.pos2D;
			_particles = pparticles;
			super(pparticles);
		}	
		
		override protected function calcForce(pparticle:Particle,pnum:uint):void{
			var radius:Vector2D=pparticle.pos2D.subtract(_center);		
			var gravityCentral:Vector2D;
			if (radius.length < 20) {
				gravityCentral = new Vector2D(0,0);
			}
			else{
				gravityCentral = Forces.gravity(_G,_massAttractor,pparticle.mass,radius);		
			}
			var gravityMutual:Vector2D = new Vector2D(0,0);
			for (var i:uint=0; i<_particles.length; i++){
				if (i != pnum){
					var particle:Particle = _particles[i];
					var radiusP:Vector2D = pparticle.pos2D.subtract(particle.pos2D);		
					if (radiusP.length < _rmin){
						var gravityP:Vector2D = Forces.gravityModified(_G,particle.mass,pparticle.mass,radiusP,_eps);	
						gravityMutual.incrementBy(gravityP);
					}
				}
			}
			force = Forces.add([gravityCentral, gravityMutual]);
		}
		
	}
}
