﻿package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Ball;		
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.math.Graph;		

	public class CentralForcer extends Forcer{
		
		private var _particle:Ball;			
		private var _center:Vector2D;
		private var _graph:Graph;	
		private var _stageWidth;
		private var _stageHeight;			
		//private var _k:Number=-10;
		//private var _n:Number=0.5;		
		//private var _k:Number=-1;
		//private var _n:Number=1;		
		private var _k:Number=-1000;
		private var _n:Number=-1;		
		//private var _k:Number=-100000;
		//private var _n:Number=-2;
		//private var _k:Number=-20000000;
		//private var _n:Number=-3;		

		public function CentralForcer(pparticle:Ball,pcenter:Ball):void{
			_particle = pparticle;		
			_center = pcenter.pos2D;
			_stageWidth = _particle.stage.stageWidth;			
			_stageHeight = _particle.stage.stageHeight;				
			setupGraph();
			super(pparticle);
		}	
		
		override protected function calcForce():void{
			var r:Vector2D = _particle.pos2D.subtract(_center);
			force = Forces.central(_k,_n,r);
		}
		
		override protected function moveObject():void{
			super.moveObject();
			plotGraph();
		}

		private function setupGraph():void {
			//_graph= new Graph(xmin,xmax,ymin,ymax,xorig,yorig,xwidth,ywidth);	
			_graph= new Graph(0,_stageWidth,0,_stageHeight,0,0,_stageWidth,_stageHeight);						
			_particle.stage.addChild(_graph);
		}
		private function plotGraph():void{
			_graph.plot([_particle.xpos], [-_particle.ypos],0x666666, false, true);		
		}	
		
	}
}
