package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.math.Graph;
	
	public class FreeOscillator extends Forcer{
		private var _object:Ball;
		private var _center:Vector2D;
		private var _displ:Vector2D;
		private var _kSpring:Number=1;		
		private var _graph:Graph;

		public function FreeOscillator(pobject:Ball,pattractor:Ball):void{
			_object = pobject;
            _center = pattractor.pos2D;
			setupGraph();
			super(_object);
		}
		
		override protected function moveObject():void{		
			super.moveObject();		
			plotGraph();
		}		
			
		override protected function calcForce():void{
            _displ=_object.pos2D.subtract(_center);
			force = Forces.spring(_kSpring,_displ);	
		}
		
		// tworzy wykres zależności przemieszczenia od czasu		
		private function setupGraph():void {
			//_graph= new Graph(xmin,xmax,ymin,ymax,xorig,yorig,xwidth,ywidth);	
			_graph= new Graph(0,20,-250,250,50,250,450,200);					
			_graph.drawgrid(5,1,50,50);			
			_graph.drawaxes('time (s)','displacement (px)');	
			_object.stage.addChild(_graph);
		}
		private function plotGraph():void{
			_graph.plot([time], [_displ.x], 0xff0000, false, true);
			_graph.plot([time], [_displ.y], 0x0000ff, false, true);
		}	
	}
}