package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Ball;		
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.math.Graph;	
	import flash.events.MouseEvent;		

	public class Parachute extends Forcer{
		
		private var _particle:Ball;		
		private var _g:Number=10;
		private var _rho:Number=0.1;
		private var _V:Number=1;
		private var _k:Number=0.01;
		private var _linearFactor:Number=3;
		private var _graph:Graph;

		public function Parachute(pparticle:Ball):void{
			_particle = pparticle;
			_particle.stage.addEventListener(MouseEvent.MOUSE_DOWN,openParachute);						
			setupGraph();
			super(pparticle);
		}	
		override protected function moveObject():void{			
			super.moveObject();		
			plotGraph();
		}		
		override protected function calcForce():void{
			var gravity:Vector2D = Forces.constantGravity(_particle.mass,_g);
			var upthrust:Vector2D = Forces.upthrust(_rho,_V,_g);
			var drag:Vector2D = Forces.drag(_k,_particle.velo2D);
			force = Forces.add([gravity, upthrust, drag]);		
		}
		private function openParachute(evt:MouseEvent):void{
			_k *= _linearFactor*_linearFactor;
			_particle.radius *= _linearFactor;			
			_particle.stage.removeEventListener(MouseEvent.MOUSE_DOWN,openParachute);		
		}		
		private function setupGraph():void{
			_graph = new Graph(0,100,0,50,50,350,450,300);			
			_graph.drawgrid(10,5,10,5);			
			_graph.drawaxes('t','vy');			
			_particle.stage.addChild(_graph);
		}
		private function plotGraph():void{
			_graph.plot([time], [_particle.vy], 0xff0000, false, true);
		}		
	}
}
