package {
	import flash.display.Sprite;	
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	public class BouncingBallDrag extends Sprite {
		private var g:Number=0.1; // przyśpieszenie due to gravity
		private var vx:Number;  // initial horizontal speed
		private var vy:Number;  // initial vertical speed
		private var ball:Ball;

		public function BouncingBallDrag() {
			init();
		}
		private function init():void {		
			ball = new Ball();
			setInitialConditions(); // move initialisation code to a separate function
			addChild(ball);	
			ball.addEventListener(MouseEvent.MOUSE_DOWN,drag);
			ball.addEventListener(MouseEvent.MOUSE_UP,drop);				
		}
		
		private function setInitialConditions():void{ // initialise ball's position and velocity 
			vx = 0;
			vy = 0;
			ball.x = 50;
			ball.y = 350;
		}

		private function onEachTimestep(evt:Event):void{

			vy += g;      // przyśpieszenie grawitacyjne increases the vertical speed
			
			ball.x += vx; // horizontal speed increases horizontal position
			ball.y += vy; // vertical speed increases vertical position
			
			if (ball.y > 350){ // if ball hits the ground
				vy *= -0.8;    // its vertical velocity reverses and reduces
			};
			if (ball.x > 550 + ball.width/2){ // take into account ball's width as it exits from right hand side
				setInitialConditions(); // recycle ball
			}

		}
		
		private function drag(evt:MouseEvent):void{
			removeEventListener(Event.ENTER_FRAME,onEachTimestep); 
			ball.startDrag();
		}
		
		private function drop(evt:MouseEvent):void{
			addEventListener(Event.ENTER_FRAME,onEachTimestep); 
			ball.stopDrag();
		}				
		
	}
}





