package{
	import flash.display.Sprite;
	import flash.geom.Vector3D;		
	import com.physicscodes.objects.PolyhedronRB;

	public class RotatingRBCube extends Sprite{
		private var _cube:PolyhedronRB;
		private var _vertices:Vector.<Vector3D>=new Vector.<Vector3D>();
		private var _faces:Vector.<Array>=new Vector.<Array>();
		private var _facesColors:Array;
		private var _radius:Number = 60; // połowa wysokości sześcianu
		private var _fl:Number = 500; // ogniskowa	
		private var _cm:Vector3D = new Vector3D(0,0,0);
		private var _im:Vector3D = new Vector3D(1,1,1);

		public function RotatingRBCube():void{
			init();
		}
		private function init():void{
			// definiuje położenie wierzchołków sześcianu względem środka masy
			_vertices[0] = new Vector3D(-_radius,-_radius,-_radius);
			_vertices[1] = new Vector3D(_radius,-_radius,-_radius);
			_vertices[2] = new Vector3D(_radius,-_radius,_radius);
			_vertices[3] = new Vector3D(-_radius,-_radius,_radius);
			_vertices[4] = new Vector3D(-_radius,_radius,-_radius);
			_vertices[5] = new Vector3D(_radius,_radius,-_radius);
			_vertices[6] = new Vector3D(_radius,_radius,_radius);
			_vertices[7] = new Vector3D(-_radius,_radius,_radius);
			// definiuje ściany sześcianu
			_faces[0] = [0,4,5,1];
			_faces[1] = [1,5,6,2];
			_faces[2] = [2,6,7,3];
			_faces[3] = [3,7,4,0];
			_faces[4] = [4,5,6,7];
			_faces[5] = [0,1,2,3];
			// fefiniuje kolory ścian
			_facesColors = [0xff0000,0x00ff00,0x0000ff,0x00ffff,0xff00ff,0xffff00];	
			// tworzy sześcian - instancję klasy PolyhedronRB
			_cube = new PolyhedronRB(_fl,_cm,_im,_vertices,_faces,_facesColors);
			addChild(_cube);
			// wprawia sześcian w ruch
			var mover:RotatingRBCubeMover = new RotatingRBCubeMover(_cube);
			mover.startTime();
		}
	}
}