package com.physicscodes.motion{

	import com.physicscodes.math.Vector2D;

	public class Forces {

		public function Forces():void {
		}
		static public function zeroForce():Vector2D {
			return (new Vector2D(0,0));
		}
		static public function constantGravity(m:Number,g:Number):Vector2D {
			return new Vector2D(0,m*g);
		}
		static public function gravity(G:Number,m1:Number,m2:Number,r:Vector2D):Vector2D {
			return r.multiply(-G*m1*m2/(r.lengthSquared*r.length));
		}	
		static public function electric(k:Number,q1:Number,q2:Number,r:Vector2D):Vector2D {
			return r.multiply(k*q1*q2/(r.lengthSquared*r.length));
		}		
		static public function forceField(q:Number,E:Vector2D):Vector2D {
			return E.multiply(q);
		}	
		static public function lorentz(q:Number,E:Vector2D,B:Number,vel:Vector2D):Vector2D {
			return E.multiply(q).add(vel.perp(q*B*vel.length));
		}		
		static public function central(k:Number,n:Number,r:Vector2D):Vector2D {
			return r.multiply(k*Math.pow(r.length,n-1));
		}		
		static public function linearDrag(k:Number,vel:Vector2D):Vector2D {
			var force:Vector2D;
			var velMag:Number=vel.length;
			if (velMag>0) {
				force=vel.multiply(-k);
			}
			else {
				force=new Vector2D(0,0);
			}
			return force;
		}
		static public function drag(k:Number,vel:Vector2D):Vector2D {
			var force:Vector2D;
			var velMag:Number=vel.length;
			if (velMag>0) {
				force=vel.multiply(-k*velMag);
			}
			else {
				force=new Vector2D(0,0);
			}
			return force;			
		}
		static public function lift(k:Number,vel:Vector2D):Vector2D {
			var force:Vector2D;
			var velMag:Number=vel.length;
			if (velMag>0) {
				force=vel.perp(k*velMag);
			}
			else {
				force=new Vector2D(0,0);
			}
			return force;			
		}			
		static public function upthrust(rho:Number,V:Number,g:Number):Vector2D {
			return new Vector2D(0,-rho*V*g);
		}	
	    static public function vortex(k:Number,r0:Number,r:Vector2D):Vector2D{
			var force:Vector2D;
			var rMag:Number=r.length;
			if (rMag > 0){
				if (rMag > r0) {
					force=r.multiply(-k*Math.pow(r0/rMag,4));
				}else{
					force=r.multiply(k);
				}
			}else{
				force=new Vector2D(0,0);
			}
			return force;
		}	
		static public function spring(k:Number,r:Vector2D):Vector2D {
			return r.multiply(-k);
		}		
		static public function damping(c:Number,vel:Vector2D):Vector2D {
			var force:Vector2D;
			var velMag:Number=vel.length;
			if (velMag>0) {
				force=vel.multiply(-c);
			}
			else {
				force=new Vector2D(0,0);
			}
			return force;
		}		
		
		static public function lennardJones(a:Number,b:Number,r:Vector2D,r0:Number):Vector2D{
			var rlen:Number = r.length;
			var mag:Number = a*Math.pow(rlen+r0,-13) - b*Math.pow(rlen+r0,-7);
			return r.multiply(mag);
		}
		static public function drop(a:Number,b:Number,r:Vector2D):Vector2D{
			var rlen:Number = r.length;
			var mag:Number = a*Math.pow(rlen,-5) - b*Math.pow(rlen,-3);
			return r.multiply(mag);
		}				
		
		static public function add(arr:Array):Vector2D {
			var forceSum:Vector2D = new Vector2D(0,0);
			for (var i:uint=0; i<arr.length; i++){
				var force:Vector2D = arr[i];
				forceSum.incrementBy(force);
			}
			return forceSum;
		}

	}
}