﻿package com.physicscodes.motion{
	import com.physicscodes.motion.Mover;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.RigidBody;		
	import com.physicscodes.math.Vector2D;

	public class ForcerRB extends Mover{
		private var _rigidBody:RigidBody;
		private var _force:Vector2D;
		private var _acc:Vector2D;	
		private var _torque:Number;	
		private var _alp:Number;		

		public function ForcerRB(prigidBody:RigidBody):void{
			_rigidBody = prigidBody;
			super(prigidBody);
		}	
		
		public function get force():Vector2D {
			return _force;
		}			
		
		public function set force(pforce:Vector2D):void {
			_force = pforce;
		}

		public function get torque():Number {
			return _torque;
		}			
		
		public function set torque(ptorque:Number):void {
			_torque = ptorque;
		}	
		
		override protected function moveObject():void{
			super.moveObject();
			calcForce();
			updateAccel();
			updateVelo();
		}		
		
		protected function calcForce():void{
			_force = Forces.zeroForce();
			_torque = 0;		
		}
		
		private function updateAccel():void{
			_acc = _force.multiply(1/_rigidBody.mass);
			_alp = _torque/_rigidBody.momentOfInertia;
		}
		
		private function updateVelo():void{
			_rigidBody.velo2D = _rigidBody.velo2D.addScaled(_acc,dt);				
			_rigidBody.angVelo += _alp*dt;	
		}
	
	}
	
}