package {
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.motion.MultiForcerPG;
	import com.physicscodes.objects.PolygonRB;
	import com.physicscodes.objects.Wall;
	
	public class RigidBodyCollider extends MultiForcerPG{
		private var _objects:Array;
		private var _wall:Wall;
		private var _g:Number=10;
		private var _cr:Number=0.4;

		public function RigidBodyCollider(pobjects:Array,pwall:Wall):void{
			_objects = pobjects;
			_wall=pwall;
            super(_objects);
		}

		override protected function calcForce(pbody:PolygonRB,pnum:uint):void{
			force = Forces.constantGravity(pbody.mass,_g);
			torque=0;
			checkWallBounce(pbody);
			for(var i:uint=0;i<_objects.length;i++){
				if(i!==pnum){
				     checkObjectCollision(pbody,_objects[i]);
				}
			}
		}
		
		private function checkWallBounce(pbody:PolygonRB):void{		
			// wykrywanie zderzenia
			var testCollision:Boolean = false;
			var testCollision2:Boolean = false;			
			var j:uint;
			var j2:uint;
			for (var i:uint=0; i<pbody.vertices.length;i++){
				if (pbody.pos2D.add(pbody.vertices[i].rotate(pbody.angDispl)).y >= _wall.p1.y){
					if (testCollision==false){
						testCollision = true;
						j = i;
					}else{ // oznacza, że jeden wierzchołek już styka się z ciałem
						//doSomethingClever();
						j2 = i;
						testCollision2 = true; // dwa wierzchołki stykają się ze ścianą						
					}
				}
			}
			// obliczenie zderzenia
			if (testCollision == true){
				pbody.ypos += pbody.pos2D.add(pbody.vertices[j].rotate(pbody.angDispl)).y*(-1) + _wall.p1.y;
				if (testCollision2 == true){ // przemieszczenie drugiego wierzchołka tak, by nie zanurzył się w ścianie
					pbody.ypos += pbody.pos2D.add(pbody.vertices[j2].rotate(pbody.angDispl)).y*(-1) + _wall.p1.y;	
					testCollision2 == false;
				}
				var normal:Vector2D = _wall.normal;
				var rp1:Vector2D = pbody.vertices[j].rotate(pbody.angDispl);
				var vp1:Vector2D = pbody.velo2D.add(rp1.perp(-pbody.angVelo*rp1.length));
				var rp1Xnormal:Number = rp1.crossProduct(normal);
				var impulse:Number = -(1+_cr)*vp1.dotProduct(normal)/(1/pbody.mass + rp1Xnormal*rp1Xnormal/pbody.momentOfInertia); 
				pbody.velo2D = pbody.velo2D.add(normal.multiply(impulse/pbody.mass));
				pbody.angVelo += rp1.crossProduct(normal)*impulse/pbody.momentOfInertia;
				testCollision = false;
			}												
		}
		
		private function checkObjectCollision(pbody1:PolygonRB, pbody2:PolygonRB):void{
			//ogólny warunek nienakładania się na siebie boksów ciał
			if(pbody1.pos2D.subtract(pbody2.pos2D).length <(pbody1.maxVertex+pbody2.maxVertex)){
				// określenie szczegółów zderzenia
				var _vertex1:Vector2D;
				var _vertex2:Vector2D;
				var _side2:Vector2D;
		
				for(var i:uint=0; i< pbody1.vertices.length;i++){
					_vertex1=pbody1.vertices[i].rotate(pbody1.angDispl).add(pbody1.pos2D);
					for(var j:uint=0; j< pbody2.vertices.length;j++){
						_vertex2=pbody2.vertices[j].rotate(pbody2.angDispl).add(pbody2.pos2D);
						_side2=pbody2.sides[j].rotate(pbody2.angDispl);
					 	var displ_vertices:Vector2D=_vertex2.subtract(_vertex1);
					 	if(displ_vertices.dotProduct(_side2.perp(1,false)) <= 0){
							break;
					 	}
					}
					if(j==pbody2.vertices.length){
						//zmiana położenia
						//oblicza odległość pomiędzy wierzchołkiem "z problemami" ciała 1 a bokiem ciała 2
						var anglRef:Number=3*Math.PI;
						for(j=0; j< pbody2.vertices.length;j++){
							_vertex2=(pbody2.vertices[j].rotate(pbody2.angDispl)).add(pbody2.pos2D);
							displ_vertices=_vertex2.subtract(_vertex1);
							var vectCheck:Vector2D=(displ_vertices.project(pbody2.sides[j].rotate(pbody2.angDispl)));
							var norm2:Vector2D=displ_vertices.subtract(vectCheck);
							if((Math.abs(Vector2D.angleBetween(pbody1.vertices[i].rotate(pbody1.angDispl).multiply(-1),norm2)) < anglRef) ){
								var displ:Vector2D=norm2;
								anglRef=Math.abs(Vector2D.angleBetween(pbody1.vertices[i].rotate(pbody1.angDispl).multiply(-1),norm2));
							}								
							if(norm2.length < 1){ // zderzenie dwóch wierzchołków
								displ=norm2;
								break;
							}
						}
						pbody1.pos2D=pbody1.pos2D.add(displ);
						checkWallBounce(pbody1);
									
						//obliczenie zderzenia
						var normal:Vector2D=norm2.para(1);
						var rp1:Vector2D=pbody1.vertices[i].rotate(pbody1.angDispl);
						var rp2:Vector2D=pbody1.pos2D.add(rp1).subtract(pbody2.pos2D);
						var vp1:Vector2D=pbody1.velo2D.add(rp1.perp(-pbody1.angVelo*rp1.length));
						var vp2:Vector2D=pbody2.velo2D.add(rp2.perp(-pbody2.angVelo*rp2.length));
						var vr:Vector2D=vp1.subtract(vp2);
						var invm1:Number=1/pbody1.mass;
						var invm2:Number=1/pbody2.mass;
						var invI1:Number=1/pbody1.momentOfInertia;
						var invI2:Number=1/pbody2.momentOfInertia;
						var rp1Xn:Number = rp1.crossProduct(normal);
						var rp2Xn:Number = rp1.crossProduct(normal);						
						var impulse:Number = -(1+_cr)*vr.dotProduct(normal)/(invm1 + invm2 + rp1Xn*rp1Xn*invI1 + rp2Xn*rp2Xn*invI2); 
						pbody1.velo2D = pbody1.velo2D.add(normal.multiply(impulse*invm1));
						pbody1.angVelo += rp1.crossProduct(normal)*impulse*invI1;
						pbody2.velo2D = pbody2.velo2D.subtract(normal.multiply(impulse*invm2));
						pbody2.angVelo += -rp2.crossProduct(normal)*impulse*invI2;
					}
				}
			}
		}
	}
}