package {
	import com.physicscodes.motion.MultiForcer2;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.objects.Star;			
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.math.Graph;			

	public class WormholeMover extends MultiForcer2{
										
		private var _particles:Array;			
		private var _attractor:Star;	
		private var _massAttractor:Number;		
		private var _radiusAttractor:Number;				
		private var _center:Vector2D;
		private var _emitterPos:Vector2D;			
		private var _G:Number = 10;		
		//private var _eps:Number = 2;
		//private var _rmin:Number = 100;
		
		public function WormholeMover(pparticles:Array,pattractor:Star,pemitter:Star):void{		
			_massAttractor = pattractor.mass;			
			_radiusAttractor = pattractor.radius;						
			_center = pattractor.pos2D;
			_emitterPos = pemitter.pos2D;
			_particles = pparticles;
			_attractor = pattractor;		
			super(pparticles);
		}	
		
		override protected function calcForce(pparticle:Particle,pnum:uint):void{
			var radius:Vector2D=pparticle.pos2D.subtract(_center);		
			var gravityCentral:Vector2D;
			if (radius.length < _attractor.radius) {
				gravityCentral = new Vector2D(0,0);
			}
			else{
				gravityCentral = Forces.gravity(_G,_massAttractor,pparticle.mass,radius);		
			}
			/*
			var gravityMutual:Vector2D = new Vector2D(0,0);
			for (var i:uint=0; i<_particles.length; i++){
				if (i != pnum){
					var particle:Particle = _particles[i];
					var radiusP:Vector2D = pparticle.pos2D.subtract(particle.pos2D);		
					if (radiusP.length < _rmin){
						var gravityP:Vector2D = Forces.gravityModified(_G,particle.mass,pparticle.mass,radiusP,_eps);	
						gravityMutual.incrementBy(gravityP);
					}
				}
			}
			force = Forces.add([gravityCentral, gravityMutual]);
			*/
			force = gravityCentral;
		}	
		
		override protected function moveObject():void{
			super.moveObject();
			recycleParticles();
		}
		
		private function recycleParticles():void{
			for (var i:uint=0; i< _particles.length; i++){
				var star:Star = _particles[i];
				var radius:Vector2D = star.pos2D.subtract(_center);	
				if (radius.length<_radiusAttractor){
					star.pos2D = _emitterPos;
					star.velo2D = new Vector2D((Math.random()-0.5)*50,Math.random()*10);
					star.radius *= 1.5;
				}			
			}
		}
	}
}
