package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;
	import flash.events.Event;	
	import flash.events.KeyboardEvent;	
	import flash.ui.Keyboard;	
	
	public class Riser extends Forcer{
		
		private var _particle:Particle;		
		private var _g:Number=10;
		private var _rho:Number=1.2;
		private var _rhoP:Number=1.1;		
		private var _k:Number=0.01;
		private var _V:Number;		
		private var _changeDensity:Boolean=false;
		private var _increment:Number=0;

		public function Riser(pparticle:Particle):void{
			_particle = pparticle;
			_particle.stage.addEventListener(KeyboardEvent.KEY_DOWN,startChangeDensity);		
			_particle.stage.addEventListener(KeyboardEvent.KEY_UP,stopChangeDensity);			
			super(pparticle);
		}	
		
		
		override protected function calcForce():void{
			var gravity:Vector2D = Forces.constantGravity(_particle.mass,_g);
			_V = _particle.mass/_rhoP;
			var upthrust:Vector2D = Forces.upthrust(_rho,_V,_g);
			var drag:Vector2D = Forces.drag(_k,_particle.velo2D);
			force = Forces.add([gravity, upthrust, drag]);		
			//force = Forces.add([gravity, upthrust]);					
		}		
		
		private function startChangeDensity(evt:KeyboardEvent):void{
			if (evt.keyCode==Keyboard.UP){
				_changeDensity = true;
				_increment = 0.001;
			}
			if (evt.keyCode==Keyboard.DOWN){
				_changeDensity = true;
				_increment = -0.001;
			}			
		}
		
		private function stopChangeDensity(evt:KeyboardEvent):void{
			_changeDensity = false;
		}		
		
		override protected function moveObject():void{			
			super.moveObject();		
			changeDensity();
		}		
		
		private function changeDensity():void{
			if (_changeDensity){
				_rhoP += _increment;
				trace(_rhoP/_rho);
			}
		}

	}
}
