﻿package{
	import flash.display.Sprite;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	
	public class MoveCurve extends Sprite{
		
		private var ball:Ball;
		private var xA:Array=new Array();
		private var yA:Array=new Array();
		private var timer:Timer;		
		private var n:int=0;		
		private var xmin=-10;
		private var xmax=10;		
		private var ymin=-50;
		private var ymax=50;		
		private var xorig=275;
		private var yorig=210;
		private var xwidth=450;
		private var ywidth=350;		
		private var xscal;
		private var yscal;
		
		public function MoveCurve(){
			init();
		}
		private function init():void{
			plotGraph();
			placeBall();
			setupTimer();
		}
		private function plotGraph():void{
			var graph:Graph = new Graph(xmin,xmax,ymin,ymax,xorig,yorig,xwidth,ywidth);			
			graph.drawgrid(2,0.4,10,2);			
			graph.drawaxes('x','y');	
			addChild(graph);
			xscal=(xmax-xmin)/xwidth;
			yscal=(ymax-ymin)/ywidth;			
			for (var i:uint=0; i<=1000; i++){
				xA[i] = (i-500)*0.02;
				yA[i] = f(xA[i]);						   
			}
			graph.plot(xA,yA,0xff0000,false,true);			
		}
		private function f(x:Number):Number{
			var y:Number;
		//	y = 0.2*(x+3.6)*(x+2.5)*(x+1)*(x-0.5)*(x-2)*(x-3.5);
		  y = (x+3.6)*(x+2.5)*(x+1)*(x-0.5)*(x-2)*(x-3.5)*Math.exp(-x*x/4);
		//	y = 0.5*x*(x+3.6)*(x+2.5)*(x+1)*(x-0.5)*(x-2)*(x-3.5)*Math.exp(-x*x/4);
		//	y = -0.1*x*x*(x+3.6)*(x+2.5)*(x+1)*(x-0.5)*(x-2)*(x-3.5)*Math.exp(-x*x/4);
			//y = Math.pow(x,5) - Math.pow(x,3) + 5*x*x - 2*x - 3;
			//y = Math.pow(x,5) - Math.pow(x,4) + x*x - 2*x - 3;
			//y = Math.log(x);
			//y = 40*Math.exp(-x*x);
			return y;
		}
		private function placeBall():void{
			ball = new Ball(6);
			ball.x = xA[0]/xscal+ xorig;
			ball.y = -yA[0]/yscal + yorig;
			addChild(ball);			
		}
		private function setupTimer():void{
			timer = new Timer(5);
			timer.addEventListener(TimerEvent.TIMER,moveBall);		
			timer.start();
		}		
		private function moveBall(evt:TimerEvent):void{
			ball.x = xA[n]/xscal + xorig;
			ball.y = -yA[n]/yscal + yorig;
			evt.updateAfterEvent();			
			n++;
			if (n==xA.length){
				timer.stop();
				timer.removeEventListener(TimerEvent.TIMER,moveBall);				
			}
		}
	}
}