﻿package{
	import flash.display.Sprite;
	import flash.display.Graphics;
	
	public class Wheel extends Sprite{
		
		private var _innerRadius:Number;
		private var _outerRadius:Number;
		private var _numSpokes:Number;
		
		public function Wheel(pIR:Number,pOR:Number,pnumS:Number):void{
			_innerRadius = pIR;
			_outerRadius = pOR;
			_numSpokes = pnumS;
			drawWheel();
		}

		private function drawWheel():void{
			with (graphics){
				beginFill(0);
				drawCircle(0,0,_outerRadius);
				endFill();
				beginFill(0xffffff);
				drawCircle(0,0,_innerRadius);
				endFill();
				lineStyle(4);
			}
			for (var n:uint=0; n<_numSpokes; n++){
				with (graphics){
					moveTo(0,0);
					lineTo(_innerRadius*Math.cos(2*Math.PI*n/_numSpokes),_innerRadius*Math.sin(2*Math.PI*n/_numSpokes));
				}
			}
		}
		
	}
}