﻿package com.physicscodes.constants{

	// all values are in SI units except where stated oherwise

	public class Astro {
		
		public static const SUN_MASS:Number = 1.9891E30;		

		public static const SUN_RADIUS:Number = 696.0E6;		
		

		public static const EARTH_MASS:Number = 5.9736E24;	// in kg	

		public static const EARTH_RADIUS:Number = 6.3710E6;	// volumetric mean in m			
		
		public static const EARTH_ORBITAL_RADIUS:Number = 149.6E9; // semimajor axis in m		
		
		public static const EARTH_ORBITAL_VELOCITY:Number = 29.78E3; // mean orbital velocity in km/s

		public static const EARTH_DENSITY:Number = 5515; // in kg/m^3		
		
		public static const EARTH_SURFACE_GRAVITY:Number = 9.798; // in m/s^2		 
		
		public static const EARTH_DAY:Number = 86400.0; // in seconds; 24.0000 hours
		
		public static const EARTH_YEAR:Number = 3.15581E7; // sidereal orbital period in seconds


		public static const MERCURY_MASS:Number = 0.3302E24;		

		public static const MERCURY_RADIUS:Number = 2.4397E6;	// volumetric mean			
		
		public static const MERCURY_ORBITAL_RADIUS:Number = 57.91E9; // semimajor axis		
		
		public static const MERCURY_ORBITAL_VELOCITY:Number = 47.87E3; // mean orbital velocity


		public static const VENUS_MASS:Number = 4.8685E24;		

		public static const VENUS_RADIUS:Number = 6.0518E6;	// volumetric mean			
		
		public static const VENUS_ORBITAL_RADIUS:Number = 108.21E9; // semimajor axis		
		
		public static const VENUS_ORBITAL_VELOCITY:Number = 35.02E3; // mean orbital velocity


		public static const MARS_MASS:Number = 0.64185E24;		

		public static const MARS_RADIUS:Number = 3.3895E6;	// volumetric mean			
		
		public static const MARS_ORBITAL_RADIUS:Number = 227.92E9; // semimajor axis		
		
		public static const MARS_ORBITAL_VELOCITY:Number = 24.13E3; // mean orbital velocity


	}
}