package com.physicscodes.motion {
	import com.physicscodes.motion.Mover;
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;

	public class MultiForcerIntegrator extends Mover{
		
		private var _particles:Array;
		private var _force:Vector2D;
		private var _acc:Vector2D;	
//		private var _oldpos:Vector2D; 	// potrzebne w standardowej metodzie Verlet
		private var _oldpos:Array = new Array(); 	// potrzebne w standardowej metodzie Verlet
		private var _olddt:Number;		// jak wyżej
		private var _n:uint=0;			// jak wyżej		

		public function MultiForcerIntegrator(pparticles:Array):void{
			_particles = pparticles;
			super(null);
		}	
		
		public function get force():Vector2D {
			return _force;
		}			
		
		public function set force(pforce:Vector2D):void {
			_force = pforce;
		}		
		
		protected function calcForce(pparticle:Particle,pnum:uint,ppos:Vector2D,pvel:Vector2D):void{
			_force = Forces.zeroForce();
		}		

		private function getAcc(pparticle:Particle,pnum:uint,ppos:Vector2D,pvel:Vector2D):Vector2D{
			calcForce(pparticle,pnum,ppos,pvel);
			return _force.multiply(1/pparticle.mass);
		}

		override protected function moveObject():void{
			for (var i:uint=0; i<_particles.length; i++){
				var particle:Particle = _particles[i];
				// wybierz jedną z metod, pozostałe oznacz komentarzem
				//EulerExplicit(particle,i);
				//EulerSemiImplicit(particle,i);
				//EulerSemiImplicit2(particle,i);
				//RK2(particle,i);
				//RK4(particle,i);			
				PositionVerlet(particle,i);
				//VelocityVerlet(particle,i);										
			}
		}
		
		override protected function spinObject():void{
			for (var i:uint=0; i<_particles.length; i++){
				var particle:Particle = _particles[i];
				if (particle.angVelo !=0){
					particle.rotation += particle.angVelo*dt*180/Math.PI; 
				}											
			}			
		}		

		private function EulerExplicit(pparticle:Particle,pnum:uint):void{			
			_acc = getAcc(pparticle,pnum,pparticle.pos2D,pparticle.velo2D); 
			pparticle.pos2D = pparticle.pos2D.addScaled(pparticle.velo2D,dt);
			pparticle.velo2D = pparticle.velo2D.addScaled(_acc,dt);			
		}
		
		private function EulerSemiImplicit(pparticle:Particle,pnum:uint):void{			
			_acc = getAcc(pparticle,pnum,pparticle.pos2D,pparticle.velo2D); 
			pparticle.velo2D = pparticle.velo2D.addScaled(_acc,dt);			
			pparticle.pos2D = pparticle.pos2D.addScaled(pparticle.velo2D,dt);			
		}
		
		private function EulerSemiImplicit2(pparticle:Particle,pnum:uint):void{			
			pparticle.pos2D = pparticle.pos2D.addScaled(pparticle.velo2D,dt);					
			_acc = getAcc(pparticle,pnum,pparticle.pos2D,pparticle.velo2D); 
			pparticle.velo2D = pparticle.velo2D.addScaled(_acc,dt);			
		}		
		
		private function PositionVerlet(pparticle:Particle,pnum:uint):void{			
			var temp:Vector2D = pparticle.pos2D; // przechowuje dane o bieżącym położeniu w zmiennej pomocniczej
			if (_n==0){ // inicjuje zmienne poprzedniego położenia i poprzedniego kroku czasowego
				_acc = getAcc(pparticle,pnum,pparticle.pos2D,pparticle.velo2D); 
				_oldpos[pnum] = pparticle.pos2D.addScaled(pparticle.velo2D,-dt).addScaled(_acc,dt*dt/2);
				_olddt = dt;
			}
			_acc = getAcc(pparticle,pnum,pparticle.pos2D,pparticle.velo2D); // wyznacza przyśpieszenie na podstawie bieżących prędkości i położenia
			pparticle.pos2D = pparticle.pos2D.addScaled(pparticle.pos2D.subtract(_oldpos[pnum]),dt/_olddt).addScaled(_acc,dt*dt); // aktualizuje wartość położenia
			pparticle.velo2D = (pparticle.pos2D.subtract(_oldpos[pnum])).multiply(0.5/dt);	// szacuje nową prędkość					
			_oldpos[pnum] = temp; // przechowuje wartość zmiennej pos sprzed aktualizacji; w następnym kroku obliczeniowym będzie to stara wartość położenia
			if (pnum==_particles.length-1){
				_olddt = dt;
				_n++;
			}
		}		
		
		private function VelocityVerlet(pparticle:Particle,pnum:uint):void{			
			_acc = getAcc(pparticle,pnum,pparticle.pos2D,pparticle.velo2D); // wyznacza przyśpieszenie na podstawie bieżących prędkości i położenia
			var accPrev:Vector2D = _acc; // zapisuje wartość prędkości do dalszych obliczeń
			pparticle.pos2D = pparticle.pos2D.addScaled(pparticle.velo2D,dt).addScaled(_acc,dt*dt/2); // aktualizuje wartość położenia
			_acc = getAcc(pparticle,pnum,pparticle.pos2D,pparticle.velo2D); // wartość przyśpieszenia na podstawie zaktualizowanych położeń; zakładamy, że siłą nie zależy jawnie od prędkości
			pparticle.velo2D = pparticle.velo2D.addScaled(_acc.add(accPrev),dt/2);	// aktualizuje położenie		
		}		

		private function RK2(pparticle:Particle,pnum:uint):void{			
			// krok 1
			var pos1:Vector2D = pparticle.pos2D;
			var vel1:Vector2D = pparticle.velo2D;
			var acc1:Vector2D = getAcc(pparticle,pnum,pos1,vel1); 
			// krok 2
			var pos2:Vector2D = pos1.addScaled(vel1,dt); 
			var vel2:Vector2D = vel1.addScaled(acc1,dt);
			var acc2:Vector2D = getAcc(pparticle,pnum,pos2,vel2); 
			// aktualizuje prędkość i położenie cząstki
			pparticle.pos2D = pos1.addScaled(vel1.add(vel2),dt/2);
			pparticle.velo2D = vel1.addScaled(acc1.add(acc2),dt/2);			
			//_acc = acc1.add(acc2).multiply(1/2); 			 
		}

		private function RK4(pparticle:Particle,pnum:uint):void{			
			// krok 1
			var pos1:Vector2D = pparticle.pos2D;
			var vel1:Vector2D = pparticle.velo2D;
			var acc1:Vector2D = getAcc(pparticle,pnum,pos1,vel1); 
			// krok 2
			var pos2:Vector2D = pos1.addScaled(vel1,dt/2); 
			var vel2:Vector2D = vel1.addScaled(acc1,dt/2);
			var acc2:Vector2D = getAcc(pparticle,pnum,pos2,vel2); 
			// krok 3
			var pos3:Vector2D = pos1.addScaled(vel2,dt/2); 
			var vel3:Vector2D = vel1.addScaled(acc2,dt/2);
			var acc3:Vector2D = getAcc(pparticle,pnum,pos3,vel3); 
			// krok 4
			var pos4:Vector2D = pos1.addScaled(vel3,dt); 
			var vel4:Vector2D = vel1.addScaled(acc3,dt);
			var acc4:Vector2D = getAcc(pparticle,pnum,pos4,vel4); 
			// sumuje vel i acc
			var velsum:Vector2D = vel1.addScaled(vel2,2).addScaled(vel3,2).add(vel4);
			var accsum:Vector2D = acc1.addScaled(acc2,2).addScaled(acc3,2).add(acc4);
			// aktualizuje prędkość i położenie cząstki
			pparticle.pos2D = pos1.addScaled(velsum,dt/6);
			pparticle.velo2D = vel1.addScaled(accsum,dt/6);			
			//_acc = accsum.multiply(1/6);
		}		
		
	
	}
	
}
