package com.physicscodes.motion{
	import com.physicscodes.motion.Mover3D;
	import com.physicscodes.motion.Forces3D;	
	import com.physicscodes.objects.RigidBody3D;		
	import flash.geom.Vector3D;	

	public class ForcerRB3D extends Mover3D{
		private var _rigidBody:RigidBody3D;
		private var _force:Vector3D;
		private var _acc:Vector3D;	
		private var _torque:Vector3D;	
		private var _alp:Vector3D;		

		public function ForcerRB3D(prigidBody:RigidBody3D):void{
			_rigidBody = prigidBody;
			super(prigidBody);
		}	
		
		public function get force():Vector3D {
			return _force;
		}			
		
		public function set force(pforce:Vector3D):void {
			_force = pforce;
		}

		public function get torque():Vector3D {
			return _torque;
		}			
		
		public function set torque(ptorque:Vector3D):void {
			_torque = ptorque;
		}	
		override protected function moveObject():void{
			super.moveObject();
			calcForce();
			updateAccel();
			updateVelo();
		}		
		
		protected function calcForce():void{
			_force = new Vector3D(0,0,0);
			_torque = new Vector3D(0,0,0);		
		}
		private function updateAccel():void{
			var vec:Vector3D = _force;
			vec.scaleBy(1/_rigidBody.mass);
			_acc = vec; // aktualizuje przyśpieszenie ruchu postępowego
			
			// (pamietaj, że wykorzystujemy wyłącznie wartości na przekątnej macierzy momentu bezwładności)
			vec=_torque;
			vec.x*=1/_rigidBody.Im.x;  
			vec.y*=1/_rigidBody.Im.y;
			vec.z*=1/_rigidBody.Im.z;
			_alp=vec; // aktualizuje przyśpieszenie ruchu obrotowego
		}
		
		private function updateVelo():void{
			var vec:Vector3D = _acc;
			vec.scaleBy(dt);
			_rigidBody.velo = _rigidBody.velo.add(vec);	// aktualizuje prędkość ruchu postępowego		
			
			vec=_alp;
			vec.scaleBy(dt);
			_rigidBody.angVelo = _rigidBody.angVelo.add(vec); // aktualizuje prędkość ruchu obrotowego	
		}

	}
	
}