﻿package com.physicscodes.objects {
	import com.physicscodes.math.Vector2D;

	public class RigidBody extends Particle{
		private var _cm:Vector2D; 	// center of mass		
		private var _im:Number;		// moment of inertia

		public function RigidBody(pcm:Vector2D,pim:Number=1,pmass:Number=1,pcharge:Number=0){
			this.mass = pmass;
			this.charge = pcharge;			
			this.pos2D = pcm; // define postion of rigid body as its center of mass 			
			_cm = pcm;
			_im = pim;
			//super(pmass,pcharge);
		}
		
		public function get momentOfInertia():Number{
			return _im;
		}
		public function set momentOfInertia(pim:Number):void{
			_im = pim;
		}		
		public function get centerOfMass():Vector2D{
			return _cm;
		}
		public function set centerOfMass(pcm:Vector2D):void{
			_cm = pcm;
			this.pos2D = pcm; 	
		}				
	}
}
