package {
	import com.physicscodes.motion.ForcerRB;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.PolygonRB;	
	import com.physicscodes.objects.Wall;	
	import com.physicscodes.math.Vector2D;

	public class RigidBodyBouncer extends ForcerRB{
		private var _body:PolygonRB;		
		private var _wall:Wall;		
		private var _g:Number=20;		
		private var _cr:Number=0.4; // współczynnik restytucji
		private var _k:Number=1; // współczynnik tłumienia prędkości kątowej

		public function RigidBodyBouncer(pbody:PolygonRB,pwall:Wall):void{
			_body = pbody;			
			_wall = pwall;
			super(pbody);
		}	
		
		override protected function calcForce():void{
			// external forces and torques
			force = Forces.constantGravity(_body.mass,_g);			
			torque = 0; // no external torque since gravity is the only force
			torque += -_k*_body.angVelo; // damping
			// wykrywanie zderzenia
			var testCollision:Boolean = false;
			var j:uint;
			for (var i:uint=0; i<_body.vertices.length;i++){
				if (_body.pos2D.add(_body.vertices[i].rotate(_body.angDispl)).y >= _wall.p1.y){
					if (testCollision==false){
						testCollision = true;
						j = i;
					}else{ // oznacza, że jeden wierzchołek już styka się z ciałem
						stopTime(); // block is lying flat on floor, so stop simulation
					}
				}
			}
			// obliczenie zderzenia
			if (testCollision == true){
				_body.ypos += _body.pos2D.add(_body.vertices[j].rotate(_body.angDispl)).y*(-1) + _wall.p1.y;
				var normal:Vector2D = _wall.normal;
				var rp1:Vector2D = _body.vertices[j].rotate(_body.angDispl);
				var vp1:Vector2D = _body.velo2D.add(rp1.perp(-_body.angVelo*rp1.length));
				var rp1Xnormal:Number = rp1.crossProduct(normal);
				var impulse:Number = -(1+_cr)*vp1.dotProduct(normal)/(1/_body.mass + rp1Xnormal*rp1Xnormal/_body.momentOfInertia); 
				_body.velo2D = _body.velo2D.add(normal.multiply(impulse/_body.mass));
				_body.angVelo += rp1.crossProduct(normal)*impulse/_body.momentOfInertia;
				testCollision = false;
			}			
		}
	}
}
