package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;			
	import com.physicscodes.objects.Ball;		
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.math.Graph;		
	import flash.events.Event;	
	import flash.events.KeyboardEvent;	
	import flash.events.MouseEvent;
	import flash.ui.Keyboard;	
	import flash.text.TextField;
	import flash.text.TextFormat;

	public class BlackHoleAttractor extends Forcer{
		private var _orbiter:Spaceship;			
		private var _attractors:Array;
		private var _massOrbiter:Number;
		private var _G:Number;
		private var _c:Number;				
		private var _stageWidth:Number;
		private var _stageHeight:Number;
		private var _yposEdge:Number;
		private var _yposWinning:Number;
		private var txtLives:TextField = new TextField();
		private var txtScore:TextField = new TextField();		
		private var txtFormat:TextFormat = new TextFormat();
		private var _applyThrust:Boolean=false;			
		private var _direction:String="";			
		private	var _dir:Vector2D=new Vector2D(0,1);		
		private var _vedmdt:Number=10; // ve*dm/dt		
		private var _numLives:uint=3;	
		private var _score:uint=0;

		public function BlackHoleAttractor(porbiter:Spaceship,pattractors:Array,pG:Number,pc:Number,pyposW:Number,pyposE:Number):void{
			_orbiter = porbiter;
			_attractors = pattractors;
			_massOrbiter = porbiter.mass;			
			_G = pG;
			_c = pc;			
			_yposEdge = pyposE;
			_yposWinning = pyposW;
			_stageWidth = _orbiter.stage.stageWidth;			
			_stageHeight = _orbiter.stage.stageHeight;				
			setupEventListeners();
			setupText();			
			super(porbiter);
		}	
		
		private function setupEventListeners():void{
			_orbiter.stage.addEventListener(KeyboardEvent.KEY_DOWN,startThrust);		
			_orbiter.stage.addEventListener(KeyboardEvent.KEY_UP,stopThrust);			
			_orbiter.stage.addEventListener(MouseEvent.DOUBLE_CLICK,changeSetup);
			_orbiter.stage.doubleClickEnabled = true;				
		}
		
		private function setupText():void{
			_orbiter.stage.addChild(txtLives);
			_orbiter.stage.addChild(txtScore);			
			txtFormat.font = "Arial";
			txtFormat.color = 0x4444ff;
			txtFormat.size = 18;
			txtLives.x = 50;
			txtLives.y = 20;			
			txtLives.width = 100;
			txtScore.x = 500;
			txtScore.y = 20;
			txtScore.width = 300;
			showLives();
		}
		
		private function startThrust(evt:KeyboardEvent):void{
			_applyThrust = true;
			if (evt.keyCode==Keyboard.UP){
				_direction = "UP";
			}	
			if (evt.keyCode==Keyboard.DOWN){
				_direction = "DOWN";
			}				
			if (evt.keyCode==Keyboard.RIGHT){
				_direction = "RIGHT";
			}
			if (evt.keyCode==Keyboard.LEFT){
				_direction = "LEFT";
			}			
		}		
		
		private function stopThrust(evt:KeyboardEvent):void{
			_applyThrust = false;
			_direction = "";
		}		
		
		private function changeSetup(evt:MouseEvent):void{
			repositionAttractors();
			recycleOrbiter();			
		}		
		
		override protected function calcForce():void{
			force = Forces.zeroForce();
			// oblicza przyciąganie ze strony wszystkich czarnych dziur i wyznacza jego wypadkową
			var gravity:Vector2D = Forces.zeroForce();			
			for (var i:uint=0; i<_attractors.length; i++){
				var attractor:Ball=_attractors[i];
				var dist:Vector2D = _orbiter.pos2D.subtract(attractor.pos2D);
				if (dist.lengthSquared > Math.pow(attractor.radius,2)){
					gravity = Forces.gravity(_G,attractor.mass,_massOrbiter,dist);	
					force = Forces.add([force, gravity]);
				}else{ // if a black hole eats the ship
					updateLives();
					recycleOrbiter();
				}
			}
			// oblicza i uwzględnia odrzut
			var thrust:Vector2D = Forces.zeroForce();			
			if (_applyThrust){
				if (_direction=="UP"){
					thrust = _dir.para(-_vedmdt);
				}else if (_direction=="DOWN"){
					thrust = _dir.para(_vedmdt);
				}else if (_direction=="RIGHT"){
					thrust = _dir.perp(_vedmdt);
				}else if (_direction=="LEFT"){
					thrust = _dir.perp(-_vedmdt);
				}else{
					thrust = new Vector2D(0,0);
				}
				force = Forces.add([force, thrust]);
			}
		}
		
		override protected function moveObject():void{
			super.moveObject();
			if (_orbiter.xpos < 0 || _orbiter.xpos > _stageWidth || _orbiter.ypos > _stageHeight){
				recycleOrbiter();
			}
			if (_orbiter.ypos < _yposWinning){
				updateScore();
				recycleOrbiter();
				addAttractor();
				repositionAttractors();
			}
			rotateOrbiter();
		}

		private function updateLives():void{
			_numLives--;
			showLives();
		}
		private function showLives():void{
			txtLives.text = String(_numLives) + " lives left";
			if (_numLives==0){
				txtLives.text = "Game over";
				stopTime();
			}
			txtLives.setTextFormat(txtFormat);			
		}

		private function updateScore():void{
			_score += _attractors.length;
			showScore();
		}
		private function showScore():void{
			if (_score==1){
				txtScore.text = "You've just dodged a black hole!"
			}else{
				txtScore.text = "You've dodged " + _score + " black holes!"
			}
			txtScore.setTextFormat(txtFormat);			
		}
		
		private function recycleOrbiter():void{
			_orbiter.pos2D = new Vector2D(_stageWidth/2,_stageHeight-50);
			_orbiter.velo2D = new Vector2D(0,0);
			_orbiter.rotation = 0;
		}

		private function rotateOrbiter():void{
			_orbiter.rotation = _orbiter.velo2D.angle*180/Math.PI + 90;
		}
		
		private function addAttractor():void{
			var radius:Number=20*(Math.random()+0.5);
			var mass:Number=(0.5*_c*_c/_G)*radius; // wzór pozwalający wyznaczyć masę czarnej dziury
			var attractor:Ball = new Ball(radius,0x000000,mass,0,false);				
			_orbiter.stage.addChild(attractor);			
			_attractors.push(attractor);
		}
		
		private function repositionAttractors():void{
			for (var i:uint=0; i<_attractors.length; i++){
				var attractor:Ball=_attractors[i];
				attractor.pos2D	= new Vector2D(Math.random()*_stageWidth,Math.random()*(_yposEdge-_yposWinning)+_yposWinning);				
			}
		}
		
	}
}
