/*
Sterowanie dwoma silnikami krokowymi za pomocą fotokomórek
poprzez Arduino i moduł EasyDriver v4.3 firmy Sparkfun
Kod oparty na licencji CC-GNU GPL. Autorzy: Ben Leduc-Mills i Dustyn Roberts
Kod został stworzony w czerwcu 2010 roku
*/

#include <Stepper.h> //importujemy bibliotekę silnika krokowego
#define STEPS 200 // 360/1.8 (kąt kroku) = 200 kroków/pełen obrót

//deklarujemy nowe obiekty z biblioteki Stepper.h (po jednym dla każdego silnika)
Stepper right_motor(STEPS, 6, 7); //6=DIR, 7=STEP
Stepper left_motor(STEPS, 11, 12); //11=DIR, 12=STEP

int distance; // jaką odległość mają pokonać silniki
int lowest; // zmienna przechowująca najniższą wartość odczytu fotokomórki
int i; // zmienna przeznaczona do pętli

// zmienne przechowujące wartości czterech fotokomórek
int photo_up;
int photo_down;
int photo_left;
int photo_right;

void setup()
{
   Serial.begin(9600); //rozpoczyna wyświetlanie wyników w porcie szeregowym

   // dobieramy szybkości silników (obroty na minutę)
   right_motor.setSpeed(200);
   left_motor.setSpeed(200);
}

void loop()
{
   //odczytuje i wyświetla wszystkie wartości fotokomórek z nóżek analogowych 0. – 3.
   photo_up = analogRead(0);
   Serial.print("Gora");
   Serial.println(photo_up);

   photo_down = analogRead(1);
   Serial.print("Dol");
   Serial.println(photo_down);

   photo_left = analogRead(2);
   Serial.print("Lewo");
   Serial.println(photo_left);

   photo_right = analogRead(3);
   Serial.print("Prawo");
   Serial.println(photo_right);

   delay(1000); //czas dla Ciebie na odczytanie wyników

   //przechowuje wartości fotokomórek w tablicy
   int photoValues[]= {photo_up, photo_down, photo_left, photo_right};

   lowest = 9999; //wartość ta powinna być wyższa od odczytywanych wartości fotokomórek

   //pętla wyszukująca najniższą wartość fotokomórki
   for(i = 0; i < 4; i++) //4 = liczba fotokomórek
      {
      Serial.println(photoValues[i]); //wyświetla tablicę photoValue

      //oznacza rzeczywistą wartość fotokomórki jako „najniższą”, jeżeli jest niższa
      //od domyślnie ustawionej „najniższej” wartości (9999)
      if (lowest >= photoValues[i] )
         {
         lowest = photoValues[i];
         }

      //wyświetla potwierdzenie wybrania najniższej wartości
      Serial.print("Najnizsza:");
      Serial.println(lowest);

      delay(1000); // odczekuje sekundę, żebyś mógł odczytać wartości

      } //koniec pętli for

   distance = lowest; //dobiera zmienną pokonywanej odległości (distance) = najniższa wartość (lowest)

   //wyszukuje czujnik, w którym pojawiła się najniższa wartość, mazak zostaje skierowany w tym kierunku
   //poniżej zostały umieszczone funkcje odpowiedzialne za ruch w górę, dół, lewo i prawo
   if (lowest == photoValues[0])
      {
      up( distance );
      }
   else if (lowest == photoValues[1])
      {
      down( distance );
      }
   else if (lowest == photoValues[2])
      {
      left( distance );
      }
   else if (lowest == photoValues[3])
      {
      right( distance );
      }
} //koniec pętli

/*
Poniżej znajdują się funkcje odpowiedzialne za ruch w danym kierunku. Rozmiar pętli = pokonywana odległość.
Wartości dodatnie to obrót zgodnie z ruchem wskazówek zegara, ujemne — w przeciwnym kierunku
*/

void up(int distance) {
   for( i = 0; i < distance; i++){
      right_motor.step(10);
      left_motor.step(-10);
   }
}

void down(int distance) {
   for( i = 0; i < distance; i++){
      right_motor.step(-10);
      left_motor.step(10);
   }
}

void left(int distance) {
   for( i = 0; i < distance; i++){
      right_motor.step(-10);
      left_motor.step(-10);
   }
}

void right(int distance) {
   for( i = 0; i < distance; i++){
      right_motor.step(10);
      left_motor.step(10);
   }
}

