/*
Sterowanie dwoma silnikami krokowymi za pomocą Arduino poprzez
moduły EasyDriver v4.3 firmy SparkFun
Autorzy: Ben Leduc-Mills i Dustyn Roberts
Kod został stworzony w czerwcu 2010 roku
*/

#include <Stepper.h> //importujemy bibliotekę silnika krokowego
#define STEPS 200 // 360/1.8 (kąt pojedynczego kroku) = 200 kroków/pełen obrót

//deklarujemy nowe obiekty z biblioteki Stepper.h (po jednym dla każdego silnika)
Stepper right_motor(STEPS, 6, 7); //6=DIR, 7=STEP
Stepper left_motor(STEPS, 11, 12); //11=DIR, 12=STEP

void setup()
{
   //dobieramy szybkości silników (obroty na minutę)
   right_motor.setSpeed(200);
   left_motor.setSpeed(200);
}

void loop()
{
   //Silniki przy każdym kroku będą wykonywać cały kod
   right_motor.step(10);
   left_motor.step(10);
   delay(10); //czas dla silnika umożliwiający wykonanie kroku
}

