/*
Wykorzystywanie domyślnego polecenia generującego sygnał PWM (analogWrite) do sterowania szybkością obrotów silnika
Do włączania silnika za pomocą sygnału wejściowego pochodzącego z przełącznika

Więcej informacji na temat sterowania sygnałem PWM za pomocą Arduino znajdziesz na stronie http://arduino.cc/en/Tutorial/PWM

Kod stworzony w czerwcu 2010 roku
Autorzy: Stina Marie Hasse Jorgensen, Sam Galison i Dustyn Roberts
Na podstawie kodu:
http://itp.nyu.edu/physcomp/Tutorials/HighCurrentLoads
*/

const int transistorPin = 9; // podłączone do bazy tranzystora
const int switchPin = 2; // podłączone do przełącznika

void setup()
{
pinMode(switchPin, INPUT); // ustanawia nóżkę przełącznika jako wejście:
pinMode(transistorPin, OUTPUT); // ustanawia nóżkę tranzystora jako wyjście:
}

void loop()
{
if (digitalRead(switchPin) == HIGH) // jeśli przełącznik jest włączony (w stanie HIGH)...
   {
   for (int i=0; i <= 255; i++) //pomalutku zwiększa prędkość
      {
      analogWrite(transistorPin, i); //przesyła wartość i do transistorPin
      delay(10);
      }

   delay(500); //odczekuje pół sekundy

   for (int j = 255; j >= 1; j--) //powoli zmniejsza prędkość
      {
      analogWrite(transistorPin, j);
      delay(10);
      }

   delay(500); //odczekuje pół sekundy
   } //kończy, jeśli

else if (digitalRead(switchPin) == LOW) // jeżeli przełącznik jest wyłączony (w stanie LOW)...
   {
   digitalWrite(transistorPin, LOW); // wyłącza silnik (stan LOW)
   }

} //koniec pętli

