/* ==============================================================================
 Obsługa serwomechanizmu
 (c)2021 Filip Sala, Marzena Sala-Tefelska
 
 Dzielnik jak i wartość rejestru porównania ICR1 
 dobrane są dla częstotliwości taktowania F_CPU = 1 MHz
 W przypadku innej częstotliwośći taktowania mikrokontrolera
 należy zmienić dzielnik, wartość ICR1 oraz podstawiane wartości OCR1A.
 Przewód sterujący (PWM) serwomechanizmu podłączamy do pinu PD5 (dla ATmega16/32)
 lub pinu PB1 (dla ATmega8, ATmega48/88/168/328)
================================================================================= */
#include <avr/io.h>
#include <util/delay.h>

int main (void)
{
 TCCR1A |= (1 << WGM11);
 TCCR1B |= (1 << WGM12) | (1 << WGM13);
 TCCR1B |= (1 << CS10); // dzielnik 1
 ICR1 = 19999;
 OCR1A = 1500; //pozycja środkowa
 TCCR1A |= (1 << COM1A1);  
 DDRD |= (1 << PD5); //dla ATmega16/32
 //DDRB |= (1 << PB1); //dla ATmega8 oraz ATmega48/88/168/328
 _delay_ms(1000);
 while (1) 
 {  
   OCR1A = 1000; //pozycja początkowa
   _delay_ms(3000);
   OCR1A = 2000; //pozycja końcowa
   _delay_ms(3000);
   OCR1A = 1500; //pozycja środkowa
   _delay_ms(3000);
 } 
} 