/* ========================================
Obsługa termistora v. 2.0
(c)2021 Filip Sala, Marzena Sala-Tefelska
===========================================*/
#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>
#include "lcd_lib.h"
#include <math.h>
#define BCoeff 3950
// R - rezystancja rezystora
#define R 10000.0
// R0 - rezystancja termistora w temp. T0
#define R0 10000.0
volatile float value;
ISR (ADC_vect)
{
 uint16_t Lbyte, Hbyte;
 Lbyte = ADCL;
 Hbyte = (ADCH & 0x03);
 value = (Lbyte + (Hbyte << 8));
}

int main (void)
{
 lcd_init();
 lcd_display_control(1, 0, 0);
 sei();
 // Inicjalizacja przetwornika analogowo-cyfrowego (ADC) 
 // w trybie free running, preskaler 128 + przerwania
 ADMUX |= (1 << REFS0); //Vref = Vcc
 //auto trigger, włączenie przerwań, właczenie ADC
 ADCSRA |=  (1 << ADIE) | (1 << ADATE) | (1 << ADEN);  // ATmega8 (1 << ADFR)
 //preskaler 128	
 ADCSRA |=  (1 << ADPS0) | (1 << ADPS1) | (1 << ADPS2); 
 ADCSRA |=  (1 << ADSC); //start konwersji
 lcd_text("Temp. = ");
 while (1)
 {
  float Rt;
  float temperature;
  Rt = R / (1023.0 / value - 1); 
  // log() - logarytm naturalny
  temperature = log (Rt / R0); 
  temperature /= BCoeff;
  temperature += 0.00335401643; // 1 /T0
  temperature = 1 / temperature;
  temperature -= 273.15; //przeliczenie z kelwinów na st. Celsjusza
  uint32_t t1;
  t1 = floorf(temperature); //wartość całkowita
  lcd_gotoXY(8,0);
  lcd_integer (t1);
  lcd_text(".");
  lcd_integer (floorf(10*(temperature - t1))); //po przecinku
  lcd_symbol(223); //lub lcd_text("*C");
  lcd_text("C     ");
  _delay_ms(500);
 }
 return 0;
}