/* =================================================
Biblioteka i2c_lib v. 1.0 do sterowania zegarami RTC
(c)2021 Filip Sala, Marzena Sala-Tefelska
====================================================*/
#ifndef I2C_LIB
#define I2C_LIB
#include <avr/io.h>
//w poniższej linii należy wpisać nazwę układu DS1307 lub PCF8563
#define DS1307
//ustawienia dla DS1307 oraz DS3231 są takie same 
#ifdef DS1307
#define SLA_W 0xD0
#define SLA_R 0xD1
#define ADDR_SEC 0x00
#define ADDR_MIN 0x01
#define ADDR_HRS 0x02
#endif //DS1307

#ifdef PCF8563
#define SLA_W 0xA2
#define SLA_R 0xA3
#define ADDR_SEC 0x02
#define ADDR_MIN 0x03
#define ADDR_HRS 0x04
#endif //PCF8563
void I2C_init(void);
void I2C_start(void);
void I2C_stop(void);
void I2C_send (uint8_t addr, uint8_t data);
uint8_t I2C_receive (uint8_t addr);
#endif //I2C_LIB