public class TestCircleWithCustomException {
  public static void main(String[] args) {
    try {
      new CircleWithCustomException(5);
      new CircleWithCustomException(-5);
      new CircleWithCustomException(0);
    }
    catch (InvalidRadiusException ex) {
      System.out.println(ex);
    }
    
    System.out.println("Liczba utworzonych obiektów: " +
      CircleWithCustomException.getNumberOfObjects());
  }
}

class CircleWithCustomException {
  /** Promień koła */
  private double radius;

  /** Liczba utworzonych obiektów */
  private static int numberOfObjects = 0;  

  /** Tworzy koło o promieniu 1 */
  public CircleWithCustomException() throws InvalidRadiusException {
    this(1.0);
  }

  /** Tworzy koło o podanym promieniu */
  public CircleWithCustomException(double newRadius) 
      throws InvalidRadiusException {
    setRadius(newRadius);
    numberOfObjects++;
  }

  /** Zwraca promień */
  public double getRadius() {
    return radius;
  }

  /** Ustawia nowy promień */
  public void setRadius(double newRadius) 
      throws InvalidRadiusException {
    if (newRadius >= 0)
      radius = newRadius;
    else
      throw new InvalidRadiusException(newRadius);
  }

  /** Zwraca wartość pola numberOfObjects */ 
  public static int getNumberOfObjects() {
    return numberOfObjects;
  }

  /** Zwraca powierzchnię koła */
  public double findArea() {
    return radius * radius * 3.14159;
  }
}
