import javafx.application.Application;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;

public class ResizableCircleRectangle extends Application {
  // Tworzenie koła i prostokąta
  private Circle circle = new Circle(60);
  private Rectangle rectangle = new Rectangle(120, 120);

  // Tworzenie panelu StockPane
  private StackPane pane = new StackPane();
  
  @Override // Przesłanianie metody start w klasie Application
  public void start(Stage primaryStage) {       
    circle.setFill(Color.GRAY);
    rectangle.setFill(Color.WHITE);
    rectangle.setStroke(Color.BLACK);
    pane.getChildren().addAll(rectangle, circle);
    
    // Tworzenie sceny i umieszczanie panelu w oknie
    Scene scene = new Scene(pane, 140, 140);
    primaryStage.setTitle("ResizableCircleRectangle"); 
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
    
    pane.widthProperty().addListener(ov -> resize());
    pane.heightProperty().addListener(ov -> resize());
  }
  
  private void resize() {
    double length = Math.min(pane.getWidth(), pane.getHeight());
    circle.setRadius(length / 2 - 15);
    rectangle.setWidth(length - 30);
    rectangle.setHeight(length - 30);
  }
  
  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
