import java.util.ArrayList;

public class RBTree<E extends Comparable<E>> extends BST<E> {
  /** Tworzy domylne drzewo czerwono-czarne */
  public RBTree() {
  }

  /** Tworzy drzewo czerwono-czarne na podstawie tablicy elementw */
  public RBTree(E[] elements) {
    super(elements);
  }

  @Override /** Przesanianie metody createNewNode, aby tworzya wzy RBTreeNode */
  protected RBTreeNode<E> createNewNode(E e) {
    return new RBTreeNode<E>(e);
  }

  @Override /** Przesanianie metody insert, aby w razie potrzeby
                wywaaa drzewo */
  public boolean insert(E e) {
    boolean successful = super.insert(e);
    if (!successful)
      return false; // e ju znajduje si w drzewie
    else {
      ensureRBTree(e); 
    }

    return true; // e zosta wstawiony
  }

  /** Gwarantuje, e drzewo jest drzewem czerwono-czarnym */
  private void ensureRBTree(E e) {
    // Pobieranie cieki z korzenia do elementu e
    ArrayList<TreeNode<E>> path = path(e);

    int i = path.size() - 1; // Indeks biecego wza w ciece
    
    // u jest ostatnim wzem w ciece i zawiera element e
    RBTreeNode<E> u = (RBTreeNode<E>)(path.get(i));
        
    // v (jeli istnieje) jest rodzicem wza u 
    RBTreeNode<E> v = (u == root) ? null : 
      (RBTreeNode<E>)(path.get(i - 1));

    u.setRed(); // Mona pokolorowa u na czerwono
          
    if (u == root) // Jeli e zosta wstawiony w korzeniu, pokoloruj korze na czarno
      u.setBlack();
    else if (v.isRed()) 
      fixDoubleRed(u, v, path, i); // Usuwanie problemu dwch kolejnych czerwonych wzw w u
  }
  
  /** Usuwa problem dwch kolejnych czerwonych wzw w u */
  private void fixDoubleRed(RBTreeNode<E> u, RBTreeNode<E> v, 
      ArrayList<TreeNode<E>> path, int i) {          
    // w jest dziadkiem u
    RBTreeNode<E> w = (RBTreeNode<E>)(path.get(i - 2));
    RBTreeNode<E> parentOfw = (w == root) ? null : 
      (RBTreeNode<E>)path.get(i - 3);

    // Pobieranie wza x (brata wza v)
    RBTreeNode<E> x = (w.left == v) ? 
      (RBTreeNode<E>)(w.right) : (RBTreeNode<E>)(w.left);
    
    if (x == null || x.isBlack()) {
      // Scenariusz 1. x (brat wza v) jest czarny
      if (w.left == v && v.left == u) {
        // Scenariusz 1.1. u < v < w, zmiana struktury i koloru wzw
        restructureRecolor(u, v, w, w, parentOfw);
    
        w.left = v.right; // v.right to y3 z rysunku 36.6
        v.right = w;
      }
      else if (w.left == v && v.right == u) {
        // Scenariusz 1.2. v < u < w, zmiana struktury i koloru wzw
        restructureRecolor(v, u, w, w, parentOfw);
        v.right = u.left;
        w.left = u.right;
        u.left = v;
        u.right = w;
      }
      else if (w.right == v && v.right == u) {
        // Scenariusz 1.3. w < v < u, zmiana struktury i koloru wzw
        restructureRecolor(w, v, u, w, parentOfw);
        w.right = v.left;
        v.left = w;
      }
      else {
        // Scenariusz 1.4. w < u < v, zmiana struktury i koloru wzw
        restructureRecolor(w, u, v, w, parentOfw);
        w.right = u.left;
        v.left = u.right;
        u.left = w;
        u.right = v;
      }
    }
    else { // Scenariusz 2. x (brat wza v) jest czerwony
      // Zmiana koloru wzw
      w.setRed();
      u.setRed();
      ((RBTreeNode<E>)(w.left)).setBlack(); 
      ((RBTreeNode<E>)(w.right)).setBlack();
      
      if (w == root) {
        w.setBlack();     
      }
      else if (((RBTreeNode<E>)parentOfw).isRed()) {  
        // Przejcie w gr cieki, aby rozwiza nowy problem dwch kolejnych czerwonych wzw
        u = w;
        v = (RBTreeNode<E>)parentOfw;
        fixDoubleRed(u, v, path, i - 2); // i  2 powoduje przejcie w gr cieki
      }
    }
  }

  /** czenie b z parentOfw i zmiana koloru a, b, c na podstawie zalenoci a < b < c */
  private void restructureRecolor(RBTreeNode<E> a, RBTreeNode<E> b, 
      RBTreeNode<E> c, RBTreeNode<E> w, RBTreeNode<E> parentOfw) {
    if (parentOfw == null)
      root = b;
    else if (parentOfw.left == w)
      parentOfw.left = b;
    else
      parentOfw.right = b;

    b.setBlack(); // b staje si korzeniem w poddrzewie
    a.setRed(); // a staje si lewym dzieckiem wza b
    c.setRed(); // c staje si prawym dzieckiem wza b
  }      
  
  @Override /** Usuwa element z drzewa RBTree.
              * Zwraca true po udanym usuniciu elementu.
              * Zwraca false, jeli element nie znajduje si w drzewie */
  public boolean delete(E e) {
    // Znajdowanie usuwanego wza
    TreeNode<E> current = root;
    while (current != null) {
      if (e.compareTo(current.element) < 0) {
        current = current.left;
      }
      else if (e.compareTo(current.element) > 0) {
        current = current.right;
      }
      else
        break; // Element is znajduje si w drzewie wskazywanym przez current
    }

    if (current == null)
      return false; // Element nie wystpuje w drzewie

    java.util.ArrayList<TreeNode<E>> path;

    // Wze current jest wzem wewntrznym
    if (current.left != null && current.right != null) {
      // Znajdowanie pierwszego od prawej wza w lewym poddrzewie wza current
      TreeNode<E> rightMost = current.left;
      while (rightMost.right != null) {
        rightMost = rightMost.right; // Naley przechodzi w prawo
      }

      path = path(rightMost.element); // Pobieranie cieki przed zastpowaniem elementw

      // Zastpowanie elementu z current elementem z rightMost
      current.element = rightMost.element;
    }
    else
      path = path(e); // Pobieranie cieki do wza current

    // Usuwanie ostatniego wza w ciece i w razie potrzeby przejcie w gr cieki
    deleteLastNodeInPath(path);
    
    size--; // Po usuniciu 1 elementu
    return true; // Element zosta usunity
  }

  /** Usuwa ostatni wze w ciece */
  public void deleteLastNodeInPath(ArrayList<TreeNode<E>> path) {
    int i = path.size() - 1; // Indeks do wza w ciece
    // u jest ostatnim wzem w ciece
    RBTreeNode<E> u = (RBTreeNode<E>)(path.get(i));
    RBTreeNode<E> parentOfu = (u == root) ? null :
      (RBTreeNode<E>)(path.get(i - 1));
    RBTreeNode<E> grandparentOfu = (parentOfu == null ||
      parentOfu == root) ? null :
      (RBTreeNode<E>)(path.get(i - 2));
    RBTreeNode<E> childOfu = (u.left == null) ?
      (RBTreeNode<E>)(u.right) : (RBTreeNode<E>)(u.left);

    // Usuwanie wza u; czenie childOfu z parentOfu
    connectNewParent(parentOfu, u, childOfu);
    
    // Zmiana koloru wzw i usunicie problemu podwjnie czarnego wza, jeli jest to konieczne
    if (childOfu == root || u.isRed())
      return; // Jeli childOfu jest korzeniem lub u jest czerwony, mona zakoczy prac
    else if (childOfu != null && childOfu.isRed()) 
      childOfu.setBlack(); // Kolorowanie childOfu na czarno  gotowe
    else // u jest czarny, childOfu jest czarny lub rwny null
      // Usunicie problemu podwjnie czarnego wza w parentOfu
      fixDoubleBlack(grandparentOfu, parentOfu, childOfu, path, i);
  }

  /** Usunicie problemu w rodzicu */
  private void fixDoubleBlack(
      RBTreeNode<E> grandparent, RBTreeNode<E> parent, 
      RBTreeNode<E> db, ArrayList<TreeNode<E>> path, int i) {
    // Pobieranie y, y1 i y2
    RBTreeNode<E> y = (parent.right == db) ? 
      (RBTreeNode<E>)(parent.left) : (RBTreeNode<E>)(parent.right);
    RBTreeNode<E> y1 = (RBTreeNode<E>)(y.left);
    RBTreeNode<E> y2 = (RBTreeNode<E>)(y.right);

    if (y.isBlack() && y1 != null && y1.isRed()) {
      if (parent.right == db) {
        // Scenariusz 1.1. y jest czarnym lewym bratem, a y1 jest czerwony
        connectNewParent(grandparent, parent, y);
        recolor(parent, y, y1); // Dostosowanie kolorw

        // Dostosowanie wskanikw do dzieci
        parent.left = y.right;
        y.right = parent;
      }
      else {
        // Scenariusz 1.3. y jest czarnym lewym bratem, a y1 jest czerwony
        connectNewParent(grandparent, parent, y1);
        recolor(parent, y1, y); // Dostosowanie kolorw

        // Dostosowanie wskanikw do dzieci
        parent.right = y1.left;
        y.left = y1.right;
        y1.left = parent;
        y1.right = y;
      }
    }
    else if (y.isBlack() && y2 != null && y2.isRed()) {
      if (parent.right == db) {
        // Scenariusz 1.2. y jest czarnym lewym bratem, a y2 jest czerwony
        connectNewParent(grandparent, parent, y2);
        recolor(parent, y2, y); // Dostosowanie kolorw

        // Dostosowanie wskanikw do dzieci
        y.right = y2.left;
        parent.left = y2.right;
        y2.left = y;
        y2.right = parent;
      }
      else {
        // Scenariusz 1.4. y jest czarnym prawym bratem, a y2 jest czerwony
        connectNewParent(grandparent, parent, y);
        recolor(parent, y, y2); // Dostosowanie kolorw

        // Dostosowywanie wskanikw do dzieci
        y.left = parent;
        parent.right = y1;
      }
    }
    else if (y.isBlack()) { 
      // Scenariusz 2. y jest czarny, a jego dzieci s czarne lub rwne null
      y.setRed(); // Kolorowanie y na czerwono
      if (parent.isRed())
        parent.setBlack(); // Gotowe
      else if (parent != root) {
        // Przenoszenie problemu podwjnie czarnego wza do rodzica;
        // rekurencyjne eliminowanie nowych wystpie problemu podwjnie czarnego wza
        db = parent;
        parent = grandparent;
        grandparent = 
          (i >= 3) ? (RBTreeNode<E>)(path.get(i - 3)) : null;
        fixDoubleBlack(grandparent, parent, db, path, i - 1);
      }
    }
    else { // y.isRed()
      if (parent.right == db) {       
        // Scenariusz 3.1. y jest czerwonym lewym dzieckiem wza parent
        parent.left = y2;
        y.right = parent;
      }
      else {
        // Scenariusz 3.2. y jest czerwonym prawym dzieckiem wza parent
        parent.right = y.left;
        y.left = parent;
      } 
      
      parent.setRed(); // Kolorowanie wza parent na czerwono
      y.setBlack(); // Kolorowanie wza y na czarno
      connectNewParent(grandparent, parent, y); // y jest nowym wzem parent
      fixDoubleBlack(y, parent, db, path, i - 1); 
    }
  }

  /** Zmiana koloru wzw parent, newParent i c. Scenariusz 1. usuwania */
  private void recolor(RBTreeNode<E> parent, 
      RBTreeNode<E> newParent, RBTreeNode<E> c) {
    // Zachowanie koloru wza parent w wle newParent
    if (parent.isRed())
      newParent.setRed(); 
    else
      newParent.setBlack();
    
    // c i parent staj si czarnymi dziemi wza newParen
    parent.setBlack();  
    c.setBlack();
  }

  /** czenie newParent z grandParent */
  private void connectNewParent(RBTreeNode<E> grandparent,
      RBTreeNode<E> parent, RBTreeNode<E> newParent) {
    if (parent == root) {
      root = newParent;
      if (root != null)
        newParent.setBlack();
    }
    else if (grandparent.left == parent)
      grandparent.left = newParent;
    else
      grandparent.right = newParent;
  }

  @Override /** Odwiedzanie wzw w porzdku preorder od poddrzewa */
  protected void preorder(TreeNode<E> root) {
    if (root == null) return;
    System.out.print(root.element +
      (((RBTreeNode<E>)root).isRed() ? " (czerwony) " : " (czarny) "));
    preorder(root.left);
    preorder(root.right);
  }

  /** RBTreeNode to klasa TreeNode plus pole reprezentujce kolor */
  protected static class RBTreeNode<E extends Comparable<E>> extends
      BST.TreeNode<E> {
    private boolean red = true; // Okrela kolor wza

    public RBTreeNode(E e) {
      super(e);
    }

    public boolean isRed() {
      return red;
    }

    public boolean isBlack() {
      return!red;
    }

    public void setBlack() {
      red = false;
    }

    public void setRed() {
      red = true;
    }

    int blackHeight;
  }
}