import java.util.Scanner;

public class PalindromeIgnoreNonAlphanumeric {
  /** Metoda main */
  public static void main(String[] args) {
    // Tworzenie obiektu typu Scanner
    Scanner input = new Scanner(System.in);

    // Wyświetlanie prośby o wpisanie łańcucha znaków
    System.out.print("Podaj łańcuch znaków: ");
    String s = input.nextLine();

    // Wyświetlanie wyniku
    System.out.println("Czy po pominięciu znaków niealfanumerycznych\n "
      + s + "jest palindromem? " + isPalindrome(s));
  }

  /** Zwraca true, jeśli łańcuch znaków jest palindromem */
  public static boolean isPalindrome(String s) {
    // Tworzenie nowego łańcucha z usuniętymi znakami niealfanumerycznymi
    String s1 = filter(s);

    // Tworzenie nowego łańcucha ze znakami odwróconymi względem s1
    String s2 = reverse(s1);

    // Sprawdzanie, czy odwrócony łańcuch jest identyczny z pierwotnym
    return s2.equals(s1);
  }

  /** Tworzy nowy łańcuch z usuniętymi znakami niealfanumerycznymi */
  public static String filter(String s) {
    // Tworzenie obiektu typu StringBuilder
    StringBuilder stringBuilder = new StringBuilder();

    // Sprawdzanie każdego znaku, aby pobrać tylko znaki alfanumeryczne
    for (int i = 0; i < s.length(); i++) {
      if (Character.isLetterOrDigit(s.charAt(i))) {
        stringBuilder.append(s.charAt(i));
      }
    }

    // Zwraca nowy przefiltrowany łańcuch znaków
    return stringBuilder.toString();
  }

  /** Tworzy nowy łańcuch otrzymany w wyniku odwrócenia przekazanego */
  public static String reverse(String s) {
    StringBuilder stringBuilder = new StringBuilder(s);
    stringBuilder.reverse(); // Wywołanie metody reverse z klasy StringBuilder
    return stringBuilder.toString();
  }
}
