import java.util.Scanner;

public class FindNearestPoints {
  public static void main(String[] args) {
    Scanner input = new Scanner(System.in);
    System.out.print("Wpisz liczbę punktów: ");
    int numberOfPoints = input.nextInt();

    // Tworzenie tablicy do przechowywania punktów
    double[][] points = new double[numberOfPoints][2];
    System.out.print("Wpisz " + numberOfPoints + " punktów: ");
    for (int i = 0; i < points.length; i++) {
      points[i][0] = input.nextDouble();
      points[i][1] = input.nextDouble();
    }

    // p1 i p2 to indeksy w tablicy punktów
    int p1 = 0, p2 = 1; // Dwa początkowe punkty
    double shortestDistance = distance(points[p1][0], points[p1][1], 
      points[p2][0], points[p2][1]); // Inicjowanie zmiennej shortestDistance
    
    // Obliczanie odległości między każdą parą punktów
    for (int i = 0; i < points.length; i++) {
      for (int j = i + 1; j < points.length; j++) {
        double distance = distance(points[i][0], points[i][1],
          points[j][0], points[j][1]); // Obliczanie odległości

        if (shortestDistance > distance) {
          p1 = i; // Aktualizowanie p1
          p2 = j; // Aktualizowanie p2
          shortestDistance = distance; // Aktualizowanie zmiennej shortestDistance 
        }
      }
    }

    // Display result
    System.out.println("The closest two points are " +
      "(" + points[p1][0] + ", " + points[p1][1] + ") and (" +
      points[p2][0] + ", " + points[p2][1] + ")");
  }

  /** Compute the distance between two points (x1, y1) and (x2, y2)*/
  public static double distance(
      double x1, double y1, double x2, double y2) {
    return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
  }
}
