import javafx.application.Application;
import javafx.stage.Stage;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;

public class ButtonDemo extends Application {
  protected Text text = new Text(50, 50, "Programowanie z JavaFX");

  protected BorderPane getPane() {
    HBox paneForButtons = new HBox(20);
    Button btLeft = new Button("W lewo",
      new ImageView("image/left.gif"));
    Button btRight = new Button("W prawo",
      new ImageView("image/right.gif"));
    paneForButtons.getChildren().addAll(btLeft, btRight);
    paneForButtons.setAlignment(Pos.CENTER);
    paneForButtons.setStyle("-fx-border-color: green");

    BorderPane pane = new BorderPane();
    pane.setBottom(paneForButtons);

    Pane paneForText = new Pane();
    paneForText.getChildren().add(text);
    pane.setCenter(paneForText);

    btLeft.setOnAction(e -> text.setX(text.getX() - 10));
    btRight.setOnAction(e -> text.setX(text.getX() + 10));

    return pane;
  }

  @Override // Przesanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(getPane(), 450, 200);
    primaryStage.setTitle("ButtonDemo"); // Nagwek
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wywietlanie okna
  }

  /**
  * Metoda main jest potrzebna tylko w IDE z ograniczon obsug
  * JavaFX. Nie jest potrzebna przy uruchamianiu kodu w wierszu polece.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
