import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;

public class BounceBallControl extends Application {
  @Override // Przesanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    BallPane ballPane = new BallPane(); // Tworzenie panelu BallPane

    // Wstrzymywanie i wznawianie animacji
    ballPane.setOnMousePressed(e -> ballPane.pause());
    ballPane.setOnMouseReleased(e -> ballPane.play());

    // Przyspieszanie i spowalnianie animacji
    ballPane.setOnKeyPressed(e -> {
      if (e.getCode() == KeyCode.UP) {
        ballPane.increaseSpeed();
      }
      else if (e.getCode() == KeyCode.DOWN) {
        ballPane.decreaseSpeed();
      }
    });

    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(ballPane, 250, 150);
    primaryStage.setTitle("BounceBallControl"); // Nagwek
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wywietlanie okna

    // Trzeba ustawi fokus po wywietleniu okna gwnego
    ballPane.requestFocus();
  }

  /**
  * Metoda main jest potrzebna tylko w IDE z ograniczon obsug
  * JavaFX. Nie jest potrzebna przy uruchamianiu kodu w wierszu polece.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
