import java.util.*;

public class TestTreeSet {
  public static void main(String[] args) {
    // Tworzenie zbioru HashSet
    Set<String> set = new HashSet<>();

    // Dodawanie łańcuchów znaków do zbioru
    set.add("Londyn");
    set.add("Paryż");
    set.add("Nowy Jork");
    set.add("San Francisco");
    set.add("Pekin");
    set.add("Nowy Jork");

    TreeSet<String> treeSet = new TreeSet<>(set);
    System.out.println("Posortowany zbiór TreeSet: "+ treeSet);

    // Używanie metod z interfejsu SortedSet
    System.out.println("first(): " + treeSet.first());
    System.out.println("last(): " + treeSet.last());
    System.out.println("headSet(\"Nowy Jork\"): " + 
      treeSet.headSet("Nowy Jork"));
    System.out.println("tailSet(\"Nowy Jork\"): " + 
      treeSet.tailSet("Nowy Jork"));

    // Używanie metod z interfejsu NavigableSet
    System.out.println("lower(\"P\"): " + treeSet.lower("P"));
    System.out.println("higher(\"P\"): " + treeSet.higher("P"));
    System.out.println("floor(\"P\"): " + treeSet.floor("P"));
    System.out.println("ceiling(\"P\"): " + treeSet.ceiling("P"));
    System.out.println("pollFirst(): " + treeSet.pollFirst());
    System.out.println("pollLast(): " + treeSet.pollLast());
    System.out.println("Nowy zbiór TreeSet: " + treeSet);
  }
}
