public class QuickSort {
  public static void quickSort(int[] list) {
    quickSort(list, 0, list.length - 1);
  }

  private static void quickSort(int[] list, int first, int last) {
    if (last > first) {
      int pivotIndex = partition(list, first, last);
      quickSort(list, first, pivotIndex - 1);
      quickSort(list, pivotIndex + 1, last);
    }
  }

  /** Podział tablicy list[first..last] */
  private static int partition(int[] list, int first, int last) {
    int pivot = list[first]; // Wybór pierwszego elementu jako osiowego
    int low = first + 1; // Indeks do wyszukiwania do przodu
    int high = last; // Indeks do wyszukiwania wstecz

    while (high > low) {
      // Przeszukiwanie od lewej do przodu
      while (low <= high && list[low] <= pivot)
        low++;

      // Przeszukiwanie od prawej wstecz
      while (low <= high && list[high] > pivot)
        high--;

      // Przestawianie dwóch elementów listy
      if (high > low) {
        int temp = list[high];
        list[high] = list[low];
        list[low] = temp;
      }
    }

    while (high > first && list[high] >= pivot)
      high--;

    // Przestawianie elementu osiowego z list[high]
    if (pivot > list[high]) {
      list[first] = list[high];
      list[high] = pivot;
      return high;
    }
    else {
      return first;
    }
  }

  /** Metoda testowa */
  public static void main(String[] args) {
    int[] list = {2, 3, 2, 5, 6, 1, -2, 3, 14, 12};
    quickSort(list);
    for (int i = 0; i < list.length; i++)
      System.out.print(list[i] + " ");
  }
}
