public class MyArrayList<E> implements MyList<E> {
  public static final int INITIAL_CAPACITY = 16;
  private E[] data = (E[])new Object[INITIAL_CAPACITY];
  private int size = 0; // Liczba elementw na licie

  /** Tworzenie pustej listy */
  public MyArrayList() {
  }

  /** Tworzenie listy na podstawie tablicy obiektw */
  public MyArrayList(E[] objects) {
    for (int i = 0; i < objects.length; i++)
      add(objects[i]); // Ostrzeenie: nie uywaj wywoania super(objects)!
  }

  @Override /** Dodawanie nowego elementu o podanym indeksie */
  public void add(int index, E e) {   
    // Upewnianie si, e indeks zawiera si w odpowiednim przedziale
    if (index < 0 || index > size)
      throw new IndexOutOfBoundsException
        ("Indeks: " + index + ", Wielko: " + size);
    
    ensureCapacity();

    // Przesuwanie elementw po podanym indeksie w prawo 
    for (int i = size - 1; i >= index; i--)
      data[i + 1] = data[i];

    // Wstawianie nowego elementu na pozycji data[index]
    data[index] = e;

    // Zwikszanie wielkoci o 1
    size++;
  } // zobacz https://liveexample.pearsoncmg.com/dsanimation/Figure24_4.html

  /** Tworzenie nowej wikszej tablicy (podwajanie biecej i dodawanie 1) */
  private void ensureCapacity() {
    if (size >= data.length) {
      E[] newData = (E[])(new Object[size * 2 + 1]);
      System.arraycopy(data, 0, newData, 0, size);
      data = newData;
    }
  }

  @Override /** Oprnianie listy */
  public void clear() {
    data = (E[])new Object[INITIAL_CAPACITY];
    size = 0;
  }

  @Override /** Zwraca true, jeli lista zawiera dany element */
  public boolean contains(Object e) {
    for (int i = 0; i < size; i++)
      if (e.equals(data[i])) return true;

    return false;
  }

  @Override /** Zwraca element o podanym indeksie */
  public E get(int index) {
    checkIndex(index);
    return data[index];
  }

  private void checkIndex(int index) {
    if (index < 0 || index >= size)
      throw new IndexOutOfBoundsException
        ("Indeks: " + index + ", Wielko: " + size);
  }
  
  @Override /** Zwraca indeks pierwszego pasujcego elementu
    * listy. -1 oznacza brak dopasowania. */
  public int indexOf(Object e) {
    for (int i = 0; i < size; i++)
      if (e.equals(data[i])) return i;

    return -1;
  }

  @Override /** Zwraca indeks ostatniego pasujcego elementu
     * listy. -1 oznacza brak dopasowania. */
  public int lastIndexOf(E e) {
    for (int i = size - 1; i >= 0; i--)
      if (e.equals(data[i])) return i;

    return -1;
  }

  @Override /** Usuwa z listy element o podanej pozycji.
     * Dalsze elementy s przesuwane w lewo.
     * Zwraca usunity element. */
  public E remove(int index) {
    checkIndex(index);
    
    E e = data[index];

    // Przesuwanie danych w lewo
    for (int j = index; j < size - 1; j++)
      data[j] = data[j + 1];

    data[size - 1] = null; // Element jest teraz rwny null

    // Zmniejszanie wielkoci
    size--;

    return e;
  } // Zobacz https://liveexample.pearsoncmg.com/dsanimation/Figure24_5.html

  @Override /** Zastpowanie elementu ze wskazanej pozycji listy
    * podanym elementem. */
  public E set(int index, E e) {
    checkIndex(index);
    E old = data[index];
    data[index] = e;
    return old;
  }

  @Override
  public String toString() {
    StringBuilder result = new StringBuilder("[");

    for (int i = 0; i < size; i++) {
      result.append(data[i]);
      if (i < size - 1) result.append(", ");
    }

    return result.toString() + "]";
  }

  /** Zmniejsza pojemno do biecej wielkoci */
  public void trimToSize() {
    if (size != data.length) { 
      E[] newData = (E[])(new Object[size]);
      System.arraycopy(data, 0, newData, 0, size);
      data = newData;
    } // Gdy size == capacity, nie trzeba zmniejsza pojemnoci
  }

  @Override /** Przesania metod iterator() zdefiniowan w interfejsie Iterable */
  public java.util.Iterator<E> iterator() {
    return new ArrayListIterator();
  }
 
  private class ArrayListIterator 
      implements java.util.Iterator<E> {
    private int current = 0; // Biecy indeks

    @Override
    public boolean hasNext() {
      return current < size;
    }

    @Override
    public E next() {
      return data[current++];
    }

    @Override // Usuwa element zwrcony przez ostatnie wywoanie next()
    public void remove() {
    	if (current == 0) // Metoda next() nie zostaa jeszcze wywoana
        throw new IllegalStateException(); 
      MyArrayList.this.remove(--current);
    }
  }
  
  @Override /** Zwraca liczb elementw na licie */
  public int size() {
    return size;
  }
}
