import javafx.application.Application;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class MenuDemo extends Application {
  private TextField tfNumber1 = new TextField();
  private TextField tfNumber2 = new TextField();
  private TextField tfResult = new TextField();
    
  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {   
    MenuBar menuBar = new MenuBar();    
    
    Menu menuOperation = new Menu("Operacje");
    Menu menuExit = new Menu("Zakończ");
    menuBar.getMenus().addAll(menuOperation, menuExit);
    
     MenuItem menuItemAdd = new MenuItem("Sumowanie");
    MenuItem menuItemSubtract = new MenuItem("Odejmowanie");
    MenuItem menuItemMultiply = new MenuItem("Mnożenie");
    MenuItem menuItemDivide = new MenuItem("Dzielenie");
    menuOperation.getItems().addAll(menuItemAdd, menuItemSubtract,
      menuItemMultiply, menuItemDivide);
    
    MenuItem menuItemClose = new MenuItem("Zamknij");
    menuExit.getItems().add(menuItemClose);
    
    menuItemAdd.setAccelerator(
      KeyCombination.keyCombination("Ctrl+S"));
    menuItemSubtract.setAccelerator(
      KeyCombination.keyCombination("Ctrl+O"));
    menuItemMultiply.setAccelerator(
      KeyCombination.keyCombination("Ctrl+M"));
    menuItemDivide.setAccelerator(
      KeyCombination.keyCombination("Ctrl+D"));
    
    HBox hBox1 = new HBox(5);
    tfNumber1.setPrefColumnCount(2);
    tfNumber2.setPrefColumnCount(2);
    tfResult.setPrefColumnCount(2);
    hBox1.getChildren().addAll(new Label("Liczba 1."), tfNumber1,
      new Label("Liczba 2."), tfNumber2, new Label("Wynik"),
      tfResult);
    hBox1.setAlignment(Pos.CENTER);
            
    HBox hBox2 = new HBox(5);
    Button btAdd = new Button("Sumowanie");
    Button btSubtract = new Button("Odejmowanie");
    Button btMultiply = new Button("Mnożenie");
    Button btDivide = new Button("Dzielenie");
    hBox2.getChildren().addAll(btAdd, btSubtract, btMultiply, btDivide);
    hBox2.setAlignment(Pos.CENTER);
    
    VBox vBox = new VBox(10);
    vBox.getChildren().addAll(menuBar, hBox1, hBox2);
    Scene scene = new Scene(vBox, 300, 250);  
    primaryStage.setTitle("MenuDemo"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
    
    // Obsługa zdarzeń generowanych przez elementy menu
    menuItemAdd.setOnAction(e -> perform('+'));
    menuItemSubtract.setOnAction(e -> perform('-'));
    menuItemMultiply.setOnAction(e -> perform('*'));
    menuItemDivide.setOnAction(e -> perform('/'));
    menuItemClose.setOnAction(e -> System.exit(0));
    
    // Obsługa zdarzeń generowanych przez przyciski
    btAdd.setOnAction(e -> perform('+'));
    btSubtract.setOnAction(e -> perform('-'));
    btMultiply.setOnAction(e -> perform('*'));
    btDivide.setOnAction(e -> perform('/'));
  }

  private void perform(char operator) {
    double number1 = Double.parseDouble(tfNumber1.getText());
    double number2 = Double.parseDouble(tfNumber2.getText());
    
    double result = 0;
    switch (operator) {
      case '+': result = number1 + number2; break;
      case '-': result = number1 - number2; break;
      case '*': result = number1 * number2; break;
      case '/': result = number1 / number2; break;
    }
    
    tfResult.setText(result + "");
  }

  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
