public class GenericSort {
  public static void main(String[] args) {
    // Tworzenie tablicy wartości typu Integer
    Integer[] intArray = {Integer.valueOf(2), Integer.valueOf(4),
      Integer.valueOf(3)};

    // Tworzenie tablicy wartości typu Double
    Double[] doubleArray = {Double.valueOf(3.4), Double.valueOf(1.3),
      Double.valueOf(-22.1)};

    // Tworzenie tablicy wartości typu Character
    Character[] charArray = {Character.valueOf('a'),
      Character.valueOf('J'), Character.valueOf('r')};

    // Tworzenie tablicy wartości typu String
     String[] stringArray = {"Tomek", "Sylwia", "Kasia"};

    // Sortowanie tablic
    sort(intArray);
    sort(doubleArray);
    sort(charArray);
    sort(stringArray);

    // Wyświetlanie posortowanych tablic
    System.out.print("Posortowane obiekty typu Integer: ");
    printList(intArray);
    System.out.print("Posortowane obiekty typu Double: ");
    printList(doubleArray);
    System.out.print("Posortowane obiekty typu Character: ");
    printList(charArray);
    System.out.print("Posortowane obiekty typu String: ");
    printList(stringArray);
  }

  /** Sortowanie tablicy obiektów umożliwiających porównywanie */
  public static <E extends Comparable<E>> void sort(E[] list) {
    E currentMin;
    int currentMinIndex;

    for (int i = 0; i < list.length - 1; i++) {
      // Znajdowanie minimum fragmentu tablicy list[i+1..list.length–2]
      currentMin = list[i];
      currentMinIndex = i;

      for (int j = i + 1; j < list.length; j++) {
        if (currentMin.compareTo(list[j]) > 0) {
          currentMin = list[j];
          currentMinIndex = j;
        }
      }

      // Przestawianie list[i] z list[currentMinIndex], jeśli jest to konieczne
      if (currentMinIndex != i) {
        list[currentMinIndex] = list[i];
        list[i] = currentMin;
      }
    }
  }

  /** Wyświetlanie tablicy obiektów */
  public static void printList(Object[] list) {
    for (int i = 0; i < list.length; i++)
      System.out.print(list[i] + " ");
    System.out.println();
  }
}
